/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.Arrays;
import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldExtractor;
import org.drools.spi.Restriction;
import org.drools.spi.ReturnValueExpression;
import org.drools.spi.Tuple;

public class ReturnValueRestriction
implements Restriction {
    private static final long serialVersionUID = 320L;
    private ReturnValueExpression expression;
    private final Declaration[] requiredDeclarations;
    private final String[] requiredGlobals;
    private final Declaration[] previousDeclarations;
    private final Declaration[] localDeclarations;
    private final Evaluator evaluator;
    private static final Declaration[] noRequiredDeclarations = new Declaration[0];
    private static final String[] noRequiredGlobals = new String[0];
    private final ReturnValueContextEntry contextEntry;

    public ReturnValueRestriction(FieldExtractor fieldExtractor, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] requiredGlobals, Evaluator evaluator) {
        this(fieldExtractor, null, previousDeclarations, localDeclarations, requiredGlobals, evaluator);
    }

    public ReturnValueRestriction(FieldExtractor fieldExtractor, ReturnValueExpression returnValueExpression, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] requiredGlobals, Evaluator evaluator) {
        this.expression = returnValueExpression;
        this.previousDeclarations = previousDeclarations != null ? previousDeclarations : noRequiredDeclarations;
        this.localDeclarations = localDeclarations != null ? localDeclarations : noRequiredDeclarations;
        this.requiredGlobals = requiredGlobals != null ? requiredGlobals : noRequiredGlobals;
        this.evaluator = evaluator;
        this.contextEntry = new ReturnValueContextEntry(fieldExtractor, previousDeclarations, localDeclarations);
        this.requiredDeclarations = new Declaration[previousDeclarations.length + localDeclarations.length];
        System.arraycopy(this.previousDeclarations, 0, this.requiredDeclarations, 0, this.previousDeclarations.length);
        System.arraycopy(this.localDeclarations, 0, this.requiredDeclarations, this.previousDeclarations.length, this.localDeclarations.length);
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public Declaration[] getPreviousDeclarations() {
        return this.previousDeclarations;
    }

    public Declaration[] getLocalDeclarations() {
        return this.localDeclarations;
    }

    public void setReturnValueExpression(ReturnValueExpression expression) {
        this.expression = expression;
    }

    public ReturnValueExpression getExpression() {
        return this.expression;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean isAllowed(Extractor extractor, Object object, Tuple tuple, WorkingMemory workingMemory) {
        try {
            return this.evaluator.evaluate(extractor, object, this.expression.evaluate(object, tuple, this.previousDeclarations, this.localDeclarations, workingMemory));
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public boolean isAllowed(Extractor extractor, Object object, InternalWorkingMemory workingMemoiry) {
        throw new UnsupportedOperationException("does not support method call isAllowed(Object object, InternalWorkingMemory workingMemoiry)");
    }

    public boolean isAllowedCachedLeft(ContextEntry context, Object object) {
        throw new UnsupportedOperationException("does not support method call isAllowed(Object object, InternalWorkingMemory workingMemoiry)");
    }

    public boolean isAllowedCachedRight(ReteTuple tuple, ContextEntry context) {
        throw new UnsupportedOperationException("does not support method call isAllowed(Object object, InternalWorkingMemory workingMemoiry)");
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.evaluator.hashCode();
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + ReturnValueRestriction.hashCode(this.localDeclarations);
        result = 31 * result + ReturnValueRestriction.hashCode(this.previousDeclarations);
        result = 31 * result + ReturnValueRestriction.hashCode(this.requiredGlobals);
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != ReturnValueRestriction.class) {
            return false;
        }
        ReturnValueRestriction other = (ReturnValueRestriction)object;
        if (this.localDeclarations.length != other.localDeclarations.length) {
            return false;
        }
        if (this.previousDeclarations.length != other.previousDeclarations.length) {
            return false;
        }
        if (this.requiredGlobals.length != other.requiredGlobals.length) {
            return false;
        }
        if (!Arrays.equals(this.localDeclarations, other.localDeclarations)) {
            return false;
        }
        if (!Arrays.equals(this.previousDeclarations, other.previousDeclarations)) {
            return false;
        }
        if (!Arrays.equals(this.requiredGlobals, other.requiredGlobals)) {
            return false;
        }
        return this.evaluator.equals(other.evaluator) && this.expression.equals(other.expression);
    }

    private static int hashCode(Object[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
        }
        return result;
    }

    public ContextEntry getContextEntry() {
        return this.contextEntry;
    }

    public static class ReturnValueContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 3563817867979321431L;
        public FieldExtractor fieldExtractor;
        public Object object;
        public ReteTuple leftTuple;
        public InternalWorkingMemory workingMemory;
        public Declaration[] previousDeclarations;
        public Declaration[] localDeclarations;
        private ContextEntry entry;

        public ReturnValueContextEntry(FieldExtractor fieldExtractor, Declaration[] previousDeclarations, Declaration[] localDeclarations) {
            this.fieldExtractor = fieldExtractor;
            this.previousDeclarations = previousDeclarations;
            this.localDeclarations = localDeclarations;
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.object = handle.getObject();
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
            this.workingMemory = workingMemory;
            this.leftTuple = tuple;
        }

        public FieldExtractor getFieldExtractor() {
            return this.fieldExtractor;
        }

        public ReteTuple getTuple() {
            return this.leftTuple;
        }

        public Object getObject() {
            return this.object;
        }

        public Declaration[] getPreviousDeclarations() {
            return this.previousDeclarations;
        }

        public Declaration[] getLocalDeclarations() {
            return this.localDeclarations;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }
    }
}

