/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import org.drools.rule.Declaration;
import org.drools.rule.FixedDuration;
import org.drools.rule.GroupElement;
import org.drools.rule.GroupElementFactory;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.LogicTransformer;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.Consequence;
import org.drools.spi.Duration;

public class Rule
implements Serializable {
    private static final long serialVersionUID = 320L;
    private String pkg;
    private final String name;
    private int salience;
    private boolean dirty;
    private Map declarations;
    private Declaration[] declarationArray;
    private GroupElement lhsRoot;
    private String dialect;
    private String agendaGroup;
    private Consequence consequence;
    private Duration duration;
    private long loadOrder;
    private boolean noLoop;
    private boolean autoFocus;
    private String activationGroup;
    private String ruleFlowGroup;
    private boolean lockOnActive;
    private boolean hasLogicalDependency;
    private boolean semanticallyValid;
    private Calendar dateEffective;
    private Calendar dateExpires;
    private boolean enabled;

    public Rule(String name, String pkg, String agendaGroup) {
        this.name = name;
        this.pkg = pkg;
        this.agendaGroup = agendaGroup;
        this.lhsRoot = GroupElementFactory.newAndInstance();
        this.semanticallyValid = true;
        this.enabled = true;
    }

    public Rule(String name, String agendaGroup) {
        this(name, null, agendaGroup);
    }

    public Rule(String name) {
        this(name, null, "MAIN");
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setDuration(long ms) {
        this.duration = new FixedDuration(ms);
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean isValid() {
        return this.consequence != null && this.isSemanticallyValid();
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public int getSalience() {
        return this.salience;
    }

    public void setSalience(int salience) {
        this.salience = salience;
    }

    public String getAgendaGroup() {
        return this.agendaGroup;
    }

    public void setAgendaGroup(String agendaGroup) {
        this.agendaGroup = agendaGroup;
    }

    public boolean getNoLoop() {
        return this.noLoop;
    }

    public boolean isEffective() {
        if (!this.enabled) {
            return false;
        }
        if (this.dateEffective == null && this.dateExpires == null) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        if (this.dateEffective != null && this.dateExpires != null) {
            return now.after(this.dateEffective) && now.before(this.dateExpires);
        }
        if (this.dateEffective != null) {
            return now.after(this.dateEffective);
        }
        return now.before(this.dateExpires);
    }

    public void setNoLoop(boolean noLoop) {
        this.noLoop = noLoop;
    }

    public boolean getAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public String getActivationGroup() {
        return this.activationGroup;
    }

    public void setActivationGroup(String activationGroup) {
        this.activationGroup = activationGroup;
    }

    public String getRuleFlowGroup() {
        return this.ruleFlowGroup;
    }

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }

    public Declaration getDeclaration(String identifier) {
        if (this.dirty || this.declarations == null) {
            this.declarations = this.lhsRoot.getOuterDeclarations();
            this.declarationArray = this.declarations.values().toArray(new Declaration[this.declarations.values().size()]);
            this.dirty = false;
        }
        return (Declaration)this.declarations.get(identifier);
    }

    public boolean hasLogicalDependency() {
        return this.hasLogicalDependency;
    }

    public void setHasLogicalDependency(boolean hasLogicalDependency) {
        this.hasLogicalDependency = hasLogicalDependency;
    }

    public boolean isLockOnActive() {
        return this.lockOnActive;
    }

    public void setLockOnActive(boolean lockOnActive) {
        this.lockOnActive = lockOnActive;
    }

    public Declaration[] getDeclarations() {
        if (this.dirty || this.declarationArray == null) {
            this.declarations = this.lhsRoot.getOuterDeclarations();
            this.declarationArray = this.declarations.values().toArray(new Declaration[this.declarations.values().size()]);
            this.dirty = false;
        }
        return this.declarationArray;
    }

    public void addPattern(RuleConditionElement element) {
        this.dirty = true;
        this.lhsRoot.addChild(element);
    }

    public GroupElement getLhs() {
        return this.lhsRoot;
    }

    public void setLhs(GroupElement lhsRoot) {
        this.dirty = true;
        this.lhsRoot = lhsRoot;
    }

    public GroupElement[] getTransformedLhs() throws InvalidPatternException {
        return LogicTransformer.getInstance().transform(this.lhsRoot);
    }

    public int getSpecifity() {
        return this.getSpecifity(this.lhsRoot);
    }

    private int getSpecifity(GroupElement ce) {
        int specificity = 0;
        Iterator it = ce.getChildren().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Pattern) {
                specificity += this.getSpecifity((Pattern)object);
                continue;
            }
            if (!(object instanceof GroupElement)) continue;
            specificity += this.getSpecifity((GroupElement)object);
        }
        return specificity;
    }

    private int getSpecifity(Pattern pattern) {
        int specificity = 0;
        Iterator it = pattern.getConstraints().iterator();
        while (it.hasNext()) {
            if (it.next() instanceof Declaration) continue;
            ++specificity;
        }
        return specificity;
    }

    public void setConsequence(Consequence consequence) {
        this.consequence = consequence;
    }

    public Consequence getConsequence() {
        return this.consequence;
    }

    public long getLoadOrder() {
        return this.loadOrder;
    }

    void setLoadOrder(long loadOrder) {
        this.loadOrder = loadOrder;
    }

    public String toString() {
        return "[Rule name=" + this.name + ", agendaGroup=" + this.agendaGroup + ", salience=" + this.salience + ", no-loop=" + this.noLoop + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != Rule.class) {
            return false;
        }
        Rule other = (Rule)object;
        return this.name.equals(other.name) && this.agendaGroup.equals(other.agendaGroup) && (this.activationGroup == null && other.activationGroup == null || this.activationGroup != null && this.activationGroup.equals(other.activationGroup)) && this.salience == other.salience && this.noLoop == other.noLoop;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setSemanticallyValid(boolean valid) {
        this.semanticallyValid = valid;
    }

    public boolean isSemanticallyValid() {
        return this.semanticallyValid;
    }

    public void setDateEffective(Calendar effectiveDate) {
        this.dateEffective = effectiveDate;
    }

    public void setDateExpires(Calendar expiresDate) {
        this.dateExpires = expiresDate;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }
}

