/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.io.Serializable;
import org.drools.ruleflow.core.IConnection;
import org.drools.ruleflow.core.INode;
import org.drools.ruleflow.core.impl.Node;

public class Connection
implements IConnection,
Serializable {
    private static final long serialVersionUID = 320L;
    private int type;
    private Node from;
    private Node to;

    private Connection() {
    }

    public Connection(INode from, INode to, int type) {
        if (from == null) {
            throw new IllegalArgumentException("From node is null!");
        }
        if (to == null) {
            throw new IllegalArgumentException("To node is null!");
        }
        if (from.equals(to)) {
            throw new IllegalArgumentException("To and from nodes are the same!");
        }
        this.from = (Node)from;
        this.to = (Node)to;
        this.type = type;
        this.from.addOutgoingConnection(this);
        this.to.addIncomingConnection(this);
    }

    public synchronized void terminate() {
        this.from.removeOutgoingConnection(this);
        this.to.removeIncomingConnection(this);
        this.type = 0;
        this.from = null;
        this.to = null;
    }

    public INode getFrom() {
        return this.from;
    }

    public INode getTo() {
        return this.to;
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object instanceof Connection) {
            Connection connection = (Connection)object;
            return this.type == connection.getType() && this.getFrom().equals(connection.getFrom()) && this.getTo().equals(connection.getTo());
        }
        return false;
    }

    public int hashCode() {
        return this.getFrom().hashCode() + 3 * this.getTo().hashCode() + 5 * this.getType();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Connection ");
        sb.append(this.getFrom());
        sb.append(" - ");
        sb.append(this.getTo());
        sb.append(" [type=");
        sb.append(this.getType());
        sb.append("]");
        return sb.toString();
    }
}

