/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.ruleflow.core.IConnection;
import org.drools.ruleflow.core.INode;

public abstract class Node
implements INode,
Serializable {
    protected static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    private long id = -1L;
    private String name;
    private List incomingConnections = new ArrayList();
    private List outgoingConnections = new ArrayList();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getIncomingConnections() {
        return Collections.unmodifiableList(this.incomingConnections);
    }

    public List getOutgoingConnections() {
        return Collections.unmodifiableList(this.outgoingConnections);
    }

    protected void addIncomingConnection(IConnection connection) {
        this.validateAddIncomingConnection(connection);
        this.incomingConnections.add(connection);
    }

    protected void validateAddIncomingConnection(IConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (this.incomingConnections.contains(connection)) {
            throw new IllegalArgumentException("Connection is already added");
        }
    }

    protected void addOutgoingConnection(IConnection connection) {
        this.validateAddOutgoingConnection(connection);
        this.outgoingConnections.add(connection);
    }

    protected void validateAddOutgoingConnection(IConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (this.outgoingConnections.contains(connection)) {
            throw new IllegalArgumentException("Connection is already added");
        }
    }

    protected void removeIncomingConnection(IConnection connection) {
        this.validateRemoveIncomingConnection(connection);
        this.incomingConnections.remove(connection);
    }

    protected void validateRemoveIncomingConnection(IConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (!this.incomingConnections.contains(connection)) {
            throw new IllegalArgumentException("Given connection <" + connection + "> is not part of the incoming connections");
        }
    }

    protected void removeOutgoingConnection(IConnection connection) {
        this.validateRemoveOutgoingConnection(connection);
        this.outgoingConnections.remove(connection);
    }

    protected void validateRemoveOutgoingConnection(IConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (!this.outgoingConnections.contains(connection)) {
            throw new IllegalArgumentException("Given connection <" + connection + "> is not part of the outgoing connections");
        }
    }
}

