/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.ruleflow.common.core.impl.Process;
import org.drools.ruleflow.core.IEndNode;
import org.drools.ruleflow.core.INode;
import org.drools.ruleflow.core.IRuleFlowProcess;
import org.drools.ruleflow.core.IStartNode;
import org.drools.ruleflow.core.IVariable;

public class RuleFlowProcess
extends Process
implements IRuleFlowProcess {
    public static final String RULEFLOW_TYPE = "RuleFlow";
    private static final long serialVersionUID = 3257005445309609272L;
    private Map nodes;
    private List variables;
    private long lastNodeId;

    public RuleFlowProcess() {
        this.setType(RULEFLOW_TYPE);
        this.nodes = new HashMap();
        this.variables = new ArrayList();
    }

    public IStartNode getStart() {
        Iterator it = this.nodes.values().iterator();
        while (it.hasNext()) {
            INode node = (INode)it.next();
            if (!(node instanceof IStartNode)) continue;
            return (IStartNode)node;
        }
        return null;
    }

    public INode[] getNodes() {
        return this.nodes.values().toArray(new INode[this.nodes.size()]);
    }

    public INode getNode(long id) {
        Long idLong = new Long(id);
        if (!this.nodes.containsKey(idLong)) {
            throw new IllegalArgumentException("Unknown node id: " + id);
        }
        return (INode)this.nodes.get(idLong);
    }

    private IEndNode getEnd() {
        Iterator it = this.nodes.values().iterator();
        while (it.hasNext()) {
            INode node = (INode)it.next();
            if (!(node instanceof IEndNode)) continue;
            return (IEndNode)node;
        }
        return null;
    }

    public void removeNode(INode node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        INode n = (INode)this.nodes.remove(new Long(node.getId()));
        if (n == null) {
            throw new IllegalArgumentException("Unknown node: " + node);
        }
    }

    public List getVariables() {
        return this.variables;
    }

    public void setVariables(List variables) {
        if (variables == null) {
            throw new IllegalArgumentException("Variables is null");
        }
        this.variables = variables;
    }

    public String[] getVariableNames() {
        String[] result = new String[this.variables.size()];
        for (int i = 0; i < this.variables.size(); ++i) {
            result[i] = ((IVariable)this.variables.get(i)).getName();
        }
        return result;
    }

    public void addNode(INode node) {
        this.validateAddNode(node);
        if (!this.nodes.containsValue(node)) {
            node.setId(++this.lastNodeId);
            this.nodes.put(new Long(node.getId()), node);
        }
    }

    private void validateAddNode(INode node) {
        if (node instanceof IStartNode && this.getStart() != null) {
            throw new IllegalArgumentException("A ruleflow process cannot have more than one start node!");
        }
        if (node instanceof IEndNode && this.getEnd() != null) {
            throw new IllegalArgumentException("A ruleflow process cannot have more than one end node!");
        }
    }
}

