/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.ruleflow.core.IConnection;
import org.drools.ruleflow.core.IEndNode;
import org.drools.ruleflow.core.IJoin;
import org.drools.ruleflow.core.INode;
import org.drools.ruleflow.core.IRuleFlowProcess;
import org.drools.ruleflow.core.IRuleFlowProcessValidationError;
import org.drools.ruleflow.core.IRuleFlowProcessValidator;
import org.drools.ruleflow.core.IRuleSetNode;
import org.drools.ruleflow.core.ISplit;
import org.drools.ruleflow.core.IStartNode;
import org.drools.ruleflow.core.IVariable;
import org.drools.ruleflow.core.impl.RuleFlowProcessValidationError;

public class RuleFlowProcessValidator
implements IRuleFlowProcessValidator {
    private static RuleFlowProcessValidator instance;

    private RuleFlowProcessValidator() {
    }

    public static RuleFlowProcessValidator getInstance() {
        if (instance == null) {
            instance = new RuleFlowProcessValidator();
        }
        return instance;
    }

    public IRuleFlowProcessValidationError[] validateProcess(IRuleFlowProcess process) {
        ArrayList<RuleFlowProcessValidationError> errors = new ArrayList<RuleFlowProcessValidationError>();
        if (process.getName() == null) {
            errors.add(new RuleFlowProcessValidationError("RuleFlow process has no name."));
        }
        if (process.getId() == null || "".equals(process.getId())) {
            errors.add(new RuleFlowProcessValidationError("RuleFlow process has no id."));
        }
        if (process.getStart() == null) {
            errors.add(new RuleFlowProcessValidationError("RuleFlow process has no start node."));
        }
        boolean startNodeFound = false;
        boolean endNodeFound = false;
        INode[] nodes = process.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            INode node = nodes[i];
            if (node instanceof IStartNode) {
                IStartNode startNode = (IStartNode)node;
                startNodeFound = true;
                if (startNode.getTo() != null) continue;
                errors.add(new RuleFlowProcessValidationError("Start node has no outgoing connection."));
                continue;
            }
            if (node instanceof IEndNode) {
                IEndNode endNode = (IEndNode)node;
                endNodeFound = true;
                if (endNode.getFrom() != null) continue;
                errors.add(new RuleFlowProcessValidationError("End node has no incoming connection."));
                continue;
            }
            if (node instanceof IRuleSetNode) {
                String ruleFlowGroup;
                IRuleSetNode ruleSetNode = (IRuleSetNode)node;
                if (ruleSetNode.getFrom() == null) {
                    errors.add(new RuleFlowProcessValidationError("RuleSet node has no incoming connection."));
                }
                if (ruleSetNode.getTo() == null) {
                    errors.add(new RuleFlowProcessValidationError("RuleSet node has no outgoing connection."));
                }
                if ((ruleFlowGroup = ruleSetNode.getRuleFlowGroup()) != null && !"".equals(ruleFlowGroup)) continue;
                errors.add(new RuleFlowProcessValidationError("RuleSet node has no ruleflow-group specified."));
                continue;
            }
            if (node instanceof ISplit) {
                ISplit split = (ISplit)node;
                if (split.getType() == 0) {
                    errors.add(new RuleFlowProcessValidationError("Split node has no type."));
                }
                if (split.getFrom() == null) {
                    errors.add(new RuleFlowProcessValidationError("Split node has no incoming connection."));
                }
                if (split.getOutgoingConnections().size() < 2) {
                    errors.add(new RuleFlowProcessValidationError("Split node does not have enough outgoing connections."));
                }
                if (split.getType() != 2 && split.getType() != 3) continue;
                Iterator it = split.getOutgoingConnections().iterator();
                while (it.hasNext()) {
                    IConnection connection = (IConnection)it.next();
                    if (split.getConstraint(connection) != null) continue;
                    errors.add(new RuleFlowProcessValidationError("An outgoing connection of a split node has no constraint."));
                }
                continue;
            }
            if (!(node instanceof IJoin)) continue;
            IJoin join = (IJoin)node;
            if (join.getType() == 0) {
                errors.add(new RuleFlowProcessValidationError("Join node has no type."));
            }
            if (join.getIncomingConnections().size() < 2) {
                errors.add(new RuleFlowProcessValidationError("Join node does not have enough incoming connections."));
            }
            if (join.getTo() != null) continue;
            errors.add(new RuleFlowProcessValidationError("Join node has no outgoing connection."));
        }
        if (!startNodeFound) {
            errors.add(new RuleFlowProcessValidationError("RuleFlow process has no start node."));
        }
        if (!endNodeFound) {
            errors.add(new RuleFlowProcessValidationError("No end node found."));
        }
        Iterator it = process.getVariables().iterator();
        while (it.hasNext()) {
            IVariable variable = (IVariable)it.next();
            if (variable.getType() != null) continue;
            errors.add(new RuleFlowProcessValidationError("A variable has no type."));
        }
        this.checkAllNodesConnectedToStart(process, errors);
        return errors.toArray(new IRuleFlowProcessValidationError[errors.size()]);
    }

    private void checkAllNodesConnectedToStart(IRuleFlowProcess process, List errors) {
        HashMap<INode, Boolean> processNodes = new HashMap<INode, Boolean>();
        INode[] nodes = process.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            INode node = nodes[i];
            processNodes.put(node, Boolean.FALSE);
        }
        IStartNode start = process.getStart();
        if (start != null) {
            this.processNode(start, processNodes);
        }
        Iterator it = processNodes.keySet().iterator();
        while (it.hasNext()) {
            INode node = (INode)it.next();
            if (!Boolean.FALSE.equals(processNodes.get(node))) continue;
            errors.add(new RuleFlowProcessValidationError("A node is not connected to the start node."));
        }
    }

    private void processNode(INode node, Map nodes) {
        if (!nodes.containsKey(node)) {
            throw new IllegalStateException("A process node is connected with a node that does not belong to the process.");
        }
        Boolean prevValue = nodes.put(node, Boolean.TRUE);
        if (prevValue == Boolean.FALSE) {
            Iterator it = node.getOutgoingConnections().iterator();
            while (it.hasNext()) {
                IConnection connection = (IConnection)it.next();
                this.processNode(connection.getTo(), nodes);
            }
        }
    }
}

