/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.util.Iterator;
import java.util.List;
import org.drools.ruleflow.core.IConnection;
import org.drools.ruleflow.core.IRuleSetNode;
import org.drools.ruleflow.core.impl.Node;

public class RuleSetNode
extends Node
implements IRuleSetNode {
    private static final long serialVersionUID = 3257285846544691769L;
    private String ruleFlowGroup;

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }

    public String getRuleFlowGroup() {
        return this.ruleFlowGroup;
    }

    public IConnection getFrom() {
        List list = this.getIncomingConnections();
        if (list.size() > 0) {
            return (IConnection)list.get(0);
        }
        return null;
    }

    public IConnection getTo() {
        List list = this.getOutgoingConnections();
        if (list.size() > 0) {
            return (IConnection)list.get(0);
        }
        return null;
    }

    protected void validateAddIncomingConnection(IConnection connection) {
        super.validateAddIncomingConnection(connection);
        if (this.getIncomingConnections().size() > 0) {
            throw new IllegalArgumentException("A RuleSetNode cannot have more than one incoming node");
        }
    }

    protected void validateAddOutgoingConnection(IConnection connection) {
        super.validateAddOutgoingConnection(connection);
        Iterator it = this.getOutgoingConnections().iterator();
        while (it.hasNext()) {
            IConnection conn = (IConnection)it.next();
            if (conn.getType() != connection.getType()) continue;
            throw new IllegalArgumentException("A RuleSetNode can have at most one outgoing node");
        }
    }
}

