/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.ruleflow.core.IConnection;
import org.drools.ruleflow.core.IConstraint;
import org.drools.ruleflow.core.ISplit;
import org.drools.ruleflow.core.impl.Node;

public class Split
extends Node
implements ISplit {
    private static final long serialVersionUID = 3258413949669159736L;
    private int type;
    private Map constraints;

    public Split() {
        this.type = 0;
        this.constraints = new HashMap();
    }

    public Split(int type) {
        this.type = type;
        this.constraints = new HashMap();
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public IConstraint getConstraint(IConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        HashMap newMap = new HashMap();
        Iterator it = this.constraints.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            newMap.put(entry.getKey(), entry.getValue());
        }
        this.constraints = newMap;
        if (this.type == 3 || this.type == 2) {
            return (IConstraint)this.constraints.get(connection);
        }
        throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with: " + this.getType());
    }

    public void setConstraint(IConnection connection, IConstraint constraint) {
        if (this.type == 3 || this.type == 2) {
            if (connection == null) {
                throw new IllegalArgumentException("connection is null");
            }
            if (!this.getOutgoingConnections().contains(connection)) {
                throw new IllegalArgumentException("connection is unknown:" + connection);
            }
        } else {
            throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with type:" + this.getType());
        }
        this.constraints.put(connection, constraint);
    }

    public Map getConstraints() {
        if (this.type == 3 || this.type == 2) {
            return Collections.unmodifiableMap(this.constraints);
        }
        throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with: " + this.getType());
    }

    public IConnection getFrom() {
        if (this.getIncomingConnections().size() > 0) {
            return (IConnection)this.getIncomingConnections().get(0);
        }
        return null;
    }

    protected void validateAddIncomingConnection(IConnection connection) {
        super.validateAddIncomingConnection(connection);
        if (this.getIncomingConnections().size() > 0) {
            throw new IllegalArgumentException("A split cannot have more than one incoming connection");
        }
    }

    protected void validateAddOutgoingConnection(IConnection connection) {
        super.validateAddOutgoingConnection(connection);
        if (connection.getType() != 1) {
            throw new IllegalArgumentException("Unknown connection type :" + connection.getType() + ", only NORMAL is allowed as outgoing connection.");
        }
    }

    public void removeOutgoingConnection(IConnection connection) {
        super.removeOutgoingConnection(connection);
        this.constraints.remove(connection);
    }
}

