/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.instance.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.ruleflow.core.IConnection;
import org.drools.ruleflow.core.IJoin;
import org.drools.ruleflow.core.INode;
import org.drools.ruleflow.instance.IRuleFlowNodeInstance;
import org.drools.ruleflow.instance.impl.RuleFlowNodeInstance;

public class RuleFlowJoinInstance
extends RuleFlowNodeInstance
implements IRuleFlowNodeInstance {
    private final Map triggers = new HashMap();

    protected IJoin getJoinNode() {
        return (IJoin)this.getNode();
    }

    public void trigger(IRuleFlowNodeInstance from) {
        IJoin join = this.getJoinNode();
        switch (join.getType()) {
            case 2: {
                this.triggerCompleted();
                break;
            }
            case 1: {
                INode node = this.getProcessInstance().getRuleFlowProcess().getNode(from.getNodeId());
                Integer count = (Integer)this.triggers.get(node);
                if (count == null) {
                    this.triggers.put(node, new Integer(1));
                } else {
                    this.triggers.put(node, new Integer(count + 1));
                }
                this.checkActivation();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal join type " + join.getType());
            }
        }
    }

    private void checkActivation() {
        IConnection connection;
        Iterator it = this.getJoinNode().getIncomingConnections().iterator();
        while (it.hasNext()) {
            connection = (IConnection)it.next();
            if (this.triggers.get(connection.getFrom()) != null) continue;
            return;
        }
        it = this.getJoinNode().getIncomingConnections().iterator();
        while (it.hasNext()) {
            connection = (IConnection)it.next();
            Integer count = (Integer)this.triggers.get(connection.getFrom());
            if (count == 1) {
                this.triggers.remove(connection.getFrom());
                continue;
            }
            this.triggers.put(connection.getFrom(), new Integer(count - 1));
        }
        this.triggerCompleted();
    }

    public void triggerCompleted() {
        this.getProcessInstance().getNodeInstance(this.getJoinNode().getTo().getTo()).trigger(this);
    }
}

