/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.instance.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.Agenda;
import org.drools.ruleflow.common.instance.impl.ProcessInstance;
import org.drools.ruleflow.core.IEndNode;
import org.drools.ruleflow.core.IJoin;
import org.drools.ruleflow.core.INode;
import org.drools.ruleflow.core.IRuleFlowProcess;
import org.drools.ruleflow.core.IRuleSetNode;
import org.drools.ruleflow.core.ISplit;
import org.drools.ruleflow.core.IStartNode;
import org.drools.ruleflow.instance.IRuleFlowNodeInstance;
import org.drools.ruleflow.instance.IRuleFlowProcessInstance;
import org.drools.ruleflow.instance.impl.EndNodeInstance;
import org.drools.ruleflow.instance.impl.RuleFlowJoinInstance;
import org.drools.ruleflow.instance.impl.RuleFlowSplitInstance;
import org.drools.ruleflow.instance.impl.StartNodeInstance;

public class RuleFlowProcessInstance
extends ProcessInstance
implements IRuleFlowProcessInstance {
    private static final long serialVersionUID = -6760756665603399413L;
    private Agenda agenda;
    private final List nodeInstances = new ArrayList();

    public IRuleFlowProcess getRuleFlowProcess() {
        return (IRuleFlowProcess)this.getProcess();
    }

    public void addNodeInstance(IRuleFlowNodeInstance nodeInstance) {
        this.nodeInstances.add(nodeInstance);
        nodeInstance.setProcessInstance(this);
    }

    public void removeNodeInstance(IRuleFlowNodeInstance nodeInstance) {
        this.nodeInstances.remove(nodeInstance);
    }

    public Collection getNodeInstances() {
        return Collections.unmodifiableCollection(this.nodeInstances);
    }

    public IRuleFlowNodeInstance getFirstNodeInstance(long nodeId) {
        Iterator iterator = this.nodeInstances.iterator();
        while (iterator.hasNext()) {
            IRuleFlowNodeInstance nodeInstance = (IRuleFlowNodeInstance)iterator.next();
            if (nodeInstance.getNodeId() != nodeId) continue;
            return nodeInstance;
        }
        return null;
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public void setAgenda(Agenda agenda) {
        this.agenda = agenda;
    }

    public IRuleFlowNodeInstance getNodeInstance(INode node) {
        if (node instanceof IRuleSetNode) {
            IRuleFlowNodeInstance result = (IRuleFlowNodeInstance)((Object)this.agenda.getRuleFlowGroup(((IRuleSetNode)node).getRuleFlowGroup()));
            result.setNodeId(node.getId());
            this.addNodeInstance(result);
            return result;
        }
        if (node instanceof ISplit) {
            IRuleFlowNodeInstance result = this.getFirstNodeInstance(node.getId());
            if (result == null) {
                result = new RuleFlowSplitInstance();
                result.setNodeId(node.getId());
                this.addNodeInstance(result);
                return result;
            }
        } else {
            if (node instanceof IJoin) {
                IRuleFlowNodeInstance result = this.getFirstNodeInstance(node.getId());
                if (result == null) {
                    result = new RuleFlowJoinInstance();
                    result.setNodeId(node.getId());
                    this.addNodeInstance(result);
                }
                return result;
            }
            if (node instanceof IStartNode) {
                StartNodeInstance result = new StartNodeInstance();
                result.setNodeId(node.getId());
                this.addNodeInstance(result);
                return result;
            }
            if (node instanceof IEndNode) {
                EndNodeInstance result = new EndNodeInstance();
                result.setNodeId(node.getId());
                this.addNodeInstance(result);
                return result;
            }
        }
        throw new IllegalArgumentException("Illegal node type: " + node.getClass());
    }

    public void start() {
        if (this.getState() != 0) {
            throw new IllegalArgumentException("A process instance can only be started once");
        }
        this.setState(1);
        this.getNodeInstance(this.getRuleFlowProcess().getStart()).trigger(null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RuleFlowProcessInstance");
        sb.append(this.getId());
        sb.append(" [processId=");
        sb.append(this.getProcess().getId());
        sb.append(",state=");
        sb.append(this.getState());
        sb.append("]");
        return sb.toString();
    }
}

