/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;
import org.drools.common.InternalFactHandle;
import org.drools.reteoo.ReteTuple;
import org.drools.rule.Declaration;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldExtractor;
import org.drools.util.Entry;
import org.drools.util.Iterator;

public abstract class AbstractHashTable
implements Serializable {
    static final int MAX_CAPACITY = 0x40000000;
    protected int size;
    protected int threshold;
    protected float loadFactor;
    protected ObjectComparator comparator;
    protected Entry[] table;
    private HashTableIterator iterator;

    public AbstractHashTable() {
        this(16, 0.75f);
    }

    public AbstractHashTable(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.comparator = EqualityEquals.getInstance();
    }

    public AbstractHashTable(Entry[] table) {
        this(0.75f, table);
    }

    public AbstractHashTable(float loadFactor, Entry[] table) {
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)table.length * loadFactor);
        this.table = table;
        this.comparator = EqualityEquals.getInstance();
    }

    public Iterator iterator() {
        if (this.iterator == null) {
            this.iterator = new HashTableIterator(this);
        }
        this.iterator.reset();
        return this.iterator;
    }

    public void setComparator(ObjectComparator comparator) {
        this.comparator = comparator;
    }

    protected void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            if (entry == null) continue;
            this.table[i] = null;
            Entry next = null;
            while (entry != null) {
                next = entry.getNext();
                int index = this.indexOf(entry.hashCode(), newTable.length);
                entry.setNext(newTable[index]);
                newTable[index] = entry;
                entry = next;
            }
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    protected Entry getBucket(int hashCode) {
        return this.table[this.indexOf(hashCode, this.table.length)];
    }

    public Entry[] getTable() {
        return this.table;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected int indexOf(int hashCode, int dataSize) {
        return hashCode & dataSize - 1;
    }

    public abstract Entry getBucket(Object var1);

    public static class TripleCompositeIndex
    implements Index {
        private FieldIndex index0;
        private FieldIndex index1;
        private FieldIndex index2;
        private int startResult;

        public TripleCompositeIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index0 = indexes[0];
            this.index1 = indexes[1];
            this.index2 = indexes[2];
        }

        public int hashCodeOf(Object object) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.extractor.getHashCode(object);
            hashCode = 31 * hashCode + this.index1.extractor.getHashCode(object);
            hashCode = 31 * hashCode + this.index2.extractor.getHashCode(object);
            return this.rehash(hashCode);
        }

        public int hashCodeOf(ReteTuple tuple) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.declaration.getHashCode(tuple.get(this.index0.declaration).getObject());
            hashCode = 31 * hashCode + this.index1.declaration.getHashCode(tuple.get(this.index1.declaration).getObject());
            hashCode = 31 * hashCode + this.index2.declaration.getHashCode(tuple.get(this.index2.declaration).getObject());
            return this.rehash(hashCode);
        }

        public boolean equal(Object right, ReteTuple tuple) {
            Object left1 = tuple.get(this.index0.declaration).getObject();
            Object left2 = tuple.get(this.index1.declaration).getObject();
            Object left3 = tuple.get(this.index2.declaration).getObject();
            return this.index0.evaluator.evaluate(this.index0.declaration.getExtractor(), left1, this.index0.extractor, right) && this.index1.evaluator.evaluate(this.index1.declaration.getExtractor(), left2, this.index1.extractor, right) && this.index2.evaluator.evaluate(this.index2.declaration.getExtractor(), left3, this.index2.extractor, right);
        }

        public boolean equal(ReteTuple tuple1, ReteTuple tuple2) {
            Object object11 = tuple1.get(this.index0.declaration).getObject();
            Object object12 = tuple2.get(this.index0.declaration).getObject();
            Object object21 = tuple1.get(this.index1.declaration).getObject();
            Object object22 = tuple2.get(this.index1.declaration).getObject();
            Object object31 = tuple1.get(this.index2.declaration).getObject();
            Object object32 = tuple2.get(this.index2.declaration).getObject();
            return this.index0.evaluator.evaluate(this.index0.declaration.getExtractor(), object11, this.index0.declaration.getExtractor(), object12) && this.index1.evaluator.evaluate(this.index1.declaration.getExtractor(), object21, this.index1.declaration.getExtractor(), object22) && this.index2.evaluator.evaluate(this.index2.declaration.getExtractor(), object31, this.index2.declaration.getExtractor(), object32);
        }

        public boolean equal(Object object1, Object object2) {
            return this.index0.evaluator.evaluate(this.index0.extractor, object1, this.index0.extractor, object2) && this.index1.evaluator.evaluate(this.index1.extractor, object1, this.index1.extractor, object2) && this.index2.evaluator.evaluate(this.index2.extractor, object1, this.index2.extractor, object2);
        }

        public int rehash(int h) {
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }
    }

    public static class DoubleCompositeIndex
    implements Index {
        private FieldIndex index0;
        private FieldIndex index1;
        private int startResult;

        public DoubleCompositeIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index0 = indexes[0];
            this.index1 = indexes[1];
        }

        public int hashCodeOf(Object object) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.extractor.getHashCode(object);
            hashCode = 31 * hashCode + this.index1.extractor.getHashCode(object);
            return this.rehash(hashCode);
        }

        public int hashCodeOf(ReteTuple tuple) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.declaration.getHashCode(tuple.get(this.index0.declaration).getObject());
            hashCode = 31 * hashCode + this.index1.declaration.getHashCode(tuple.get(this.index1.declaration).getObject());
            return this.rehash(hashCode);
        }

        public boolean equal(Object right, ReteTuple tuple) {
            Object left1 = tuple.get(this.index0.declaration).getObject();
            Object left2 = tuple.get(this.index1.declaration).getObject();
            return this.index0.evaluator.evaluate(this.index0.declaration.getExtractor(), left1, this.index0.extractor, right) && this.index1.evaluator.evaluate(this.index1.declaration.getExtractor(), left2, this.index1.extractor, right);
        }

        public boolean equal(ReteTuple tuple1, ReteTuple tuple2) {
            Object object11 = tuple1.get(this.index0.declaration).getObject();
            Object object12 = tuple2.get(this.index0.declaration).getObject();
            Object object21 = tuple1.get(this.index1.declaration).getObject();
            Object object22 = tuple2.get(this.index1.declaration).getObject();
            return this.index0.evaluator.evaluate(this.index0.declaration.getExtractor(), object11, this.index0.declaration.getExtractor(), object12) && this.index1.evaluator.evaluate(this.index1.declaration.getExtractor(), object21, this.index1.declaration.getExtractor(), object22);
        }

        public boolean equal(Object object1, Object object2) {
            return this.index0.evaluator.evaluate(this.index0.extractor, object1, this.index0.extractor, object2) && this.index1.evaluator.evaluate(this.index1.extractor, object1, this.index1.extractor, object2);
        }

        public int rehash(int h) {
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }
    }

    public static class SingleIndex
    implements Index {
        private FieldExtractor extractor;
        private Declaration declaration;
        private Evaluator evaluator;
        private int startResult;

        public SingleIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.extractor = indexes[0].extractor;
            this.declaration = indexes[0].declaration;
            this.evaluator = indexes[0].evaluator;
        }

        public int hashCodeOf(Object object) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.extractor.getHashCode(object);
            return this.rehash(hashCode);
        }

        public int hashCodeOf(ReteTuple tuple) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.declaration.getHashCode(tuple.get(this.declaration).getObject());
            return this.rehash(hashCode);
        }

        public boolean equal(Object right, ReteTuple tuple) {
            Object left = tuple.get(this.declaration).getObject();
            return this.evaluator.evaluate(this.declaration.getExtractor(), left, this.extractor, right);
        }

        public boolean equal(Object object1, Object object2) {
            return this.evaluator.evaluate(this.extractor, object1, this.extractor, object2);
        }

        public boolean equal(ReteTuple tuple1, ReteTuple tuple2) {
            Object object1 = tuple1.get(this.declaration).getObject();
            Object object2 = tuple2.get(this.declaration).getObject();
            return this.evaluator.evaluate(this.declaration.getExtractor(), object1, this.declaration.getExtractor(), object2);
        }

        public int rehash(int h) {
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }
    }

    public static interface Index {
        public int hashCodeOf(ReteTuple var1);

        public int hashCodeOf(Object var1);

        public boolean equal(Object var1, ReteTuple var2);

        public boolean equal(ReteTuple var1, ReteTuple var2);

        public boolean equal(Object var1, Object var2);
    }

    public static class FieldIndex {
        FieldExtractor extractor;
        Declaration declaration;
        public Evaluator evaluator;

        public FieldIndex(FieldExtractor extractor, Declaration declaration, Evaluator evaluator) {
            this.extractor = extractor;
            this.declaration = declaration;
            this.evaluator = evaluator;
        }

        public Declaration getDeclaration() {
            return this.declaration;
        }

        public FieldExtractor getExtractor() {
            return this.extractor;
        }

        public Evaluator getEvaluator() {
            return this.evaluator;
        }
    }

    public static class FactEntry
    implements Entry {
        private static final long serialVersionUID = 1776798977330980128L;
        public InternalFactHandle handle;
        public int hashCode;
        public Entry next;

        public FactEntry(InternalFactHandle handle) {
            this.handle = handle;
            this.hashCode = handle.hashCode();
        }

        public FactEntry(InternalFactHandle handle, int hashCode) {
            this.handle = handle;
            this.hashCode = hashCode;
        }

        public InternalFactHandle getFactHandle() {
            return this.handle;
        }

        public Entry getNext() {
            return this.next;
        }

        public void setNext(Entry next) {
            this.next = next;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            return object == this || this.handle == ((FactEntry)object).handle;
        }

        public String toString() {
            return "FactEntry( handle=" + this.handle + " hashcode=" + this.hashCode + " next=" + this.next + " )";
        }
    }

    public static class EqualityEquals
    implements ObjectComparator {
        private static final long serialVersionUID = 8004812231695147987L;
        public static ObjectComparator INSTANCE = new EqualityEquals();

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        public int hashCodeOf(Object key) {
            return this.rehash(key.hashCode());
        }

        public int rehash(int h) {
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }

        private EqualityEquals() {
        }

        public boolean equal(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return object1.equals(object2);
        }
    }

    public static class InstanceEquals
    implements ObjectComparator {
        private static final long serialVersionUID = 1835792402650440794L;
        public static ObjectComparator INSTANCE = new InstanceEquals();

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        public int hashCodeOf(Object key) {
            return this.rehash(key.hashCode());
        }

        public int rehash(int h) {
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }

        private InstanceEquals() {
        }

        public boolean equal(Object object1, Object object2) {
            return object1 == object2;
        }
    }

    public static class HashTableIterator
    implements Iterator {
        private static final long serialVersionUID = -3058359667332106450L;
        private AbstractHashTable hashTable;
        private Entry[] table;
        private int row;
        private int length;
        private Entry entry;

        public HashTableIterator(AbstractHashTable hashTable) {
            this.hashTable = hashTable;
        }

        public Entry next() {
            if (this.entry == null) {
                while (this.entry == null) {
                    ++this.row;
                    if (this.row == this.length) {
                        return null;
                    }
                    this.entry = this.table[this.row];
                }
            } else {
                this.entry = this.entry.getNext();
                if (this.entry == null) {
                    this.entry = this.next();
                }
            }
            return this.entry;
        }

        public void reset() {
            this.table = this.hashTable.getTable();
            this.length = this.table.length;
            this.row = -1;
            this.entry = null;
        }
    }

    public static interface ObjectComparator
    extends Serializable {
        public int hashCodeOf(Object var1);

        public int rehash(int var1);

        public boolean equal(Object var1, Object var2);
    }
}

