/*
 * Decompiled with CFR 0.152.
 */
package org.drools.brms.server.converter;

import org.drools.RuntimeDroolsException;
import org.drools.brms.client.modeldriven.brxml.CompositeFactPattern;
import org.drools.brms.client.modeldriven.brxml.ConnectiveConstraint;
import org.drools.brms.client.modeldriven.brxml.Constraint;
import org.drools.brms.client.modeldriven.brxml.DSLSentence;
import org.drools.brms.client.modeldriven.brxml.FactPattern;
import org.drools.brms.client.modeldriven.brxml.IPattern;
import org.drools.brms.client.modeldriven.brxml.RuleAttribute;
import org.drools.brms.client.modeldriven.brxml.RuleModel;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.VariableRestrictionDescr;

public class BRXMLToDescrConverter {
    public RuleDescr toDescr(RuleModel model, String ruleName) {
        RuleDescr rule = new RuleDescr(ruleName);
        this.addAttributes(rule, model.attributes);
        this.addLHS(rule, model.lhs);
        return rule;
    }

    private void addLHS(RuleDescr rule, IPattern[] lhs) {
        AndDescr lhsDescr = new AndDescr();
        rule.setLhs(lhsDescr);
        for (int i = 0; i < lhs.length; ++i) {
            IPattern cond = lhs[i];
            if (cond instanceof DSLSentence) continue;
            if (cond instanceof FactPattern) {
                this.addFact(lhsDescr, (FactPattern)cond);
                continue;
            }
            if (!(cond instanceof CompositeFactPattern)) continue;
            this.addComposite(lhsDescr, (CompositeFactPattern)cond);
        }
    }

    private void addComposite(ConditionalElementDescr ce, CompositeFactPattern pattern) {
        BaseDescr inner = null;
        if ("or".equals(pattern.type)) {
            inner = new OrDescr();
        } else if ("not".equals(pattern.type)) {
            inner = new NotDescr();
        } else if ("exists".equals(pattern.type)) {
            inner = new ExistsDescr();
        }
        for (int i = 0; i < pattern.patterns.length; ++i) {
            this.addFact((ConditionalElementDescr)((Object)inner), pattern.patterns[i]);
        }
        ce.addDescr(inner);
    }

    private void addFact(ConditionalElementDescr ce, FactPattern factPattern) {
        PatternDescr pattern = new PatternDescr(factPattern.factType);
        pattern.setIdentifier(factPattern.boundName);
        ce.addDescr(pattern);
        for (int i = 0; i < factPattern.constraints.length; ++i) {
            Constraint constr = factPattern.constraints[i];
            if (constr.fieldBinding != null) {
                FieldBindingDescr fieldDescr = new FieldBindingDescr(constr.fieldName, constr.fieldBinding);
                pattern.addDescr(fieldDescr);
            }
            if (constr.constraintValueType == 5) {
                PredicateDescr predicateDescr = new PredicateDescr(constr.value);
                pattern.addDescr(predicateDescr);
                continue;
            }
            FieldConstraintDescr constrDescr = new FieldConstraintDescr(constr.fieldName);
            constrDescr.addRestriction(this.getFieldRestriction(constr.constraintValueType, constr.operator, constr.value));
            if (constr.connectives != null) {
                for (int j = 0; j < constr.connectives.length; ++j) {
                    ConnectiveConstraint conn = constr.connectives[j];
                    if (conn.isANDConnective()) {
                        RestrictionConnectiveDescr andDescr = new RestrictionConnectiveDescr(0);
                        constrDescr.addRestriction(andDescr);
                    } else if (conn.isORConnective()) {
                        RestrictionConnectiveDescr orDescr = new RestrictionConnectiveDescr(1);
                        constrDescr.addRestriction(orDescr);
                    } else {
                        throw new IllegalStateException("Unknown connective type/operator: [" + conn.operator + "]");
                    }
                    constrDescr.addRestriction(this.getFieldRestriction(conn.constraintValueType, conn.operator, conn.value));
                }
            }
            pattern.addDescr(constrDescr);
        }
    }

    private RestrictionDescr getFieldRestriction(int type, String operator, String value) {
        switch (type) {
            case 1: {
                LiteralRestrictionDescr lit = new LiteralRestrictionDescr(operator, value);
                return lit;
            }
            case 2: {
                VariableRestrictionDescr var = new VariableRestrictionDescr(operator, value);
                return var;
            }
            case 4: {
                LiteralRestrictionDescr enu = new LiteralRestrictionDescr(operator, value, true);
                return enu;
            }
            case 3: {
                ReturnValueRestrictionDescr rvc = new ReturnValueRestrictionDescr(operator, value);
                return rvc;
            }
        }
        throw new RuntimeDroolsException("Undefined constraint type in ROM: " + type);
    }

    private void addAttributes(RuleDescr rule, RuleAttribute[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            RuleAttribute at = attributes[i];
            AttributeDescr attr = new AttributeDescr(at.attributeName, at.value == null ? "true" : at.value);
            rule.addAttribute(attr);
        }
    }
}

