/*
 * Decompiled with CFR 0.152.
 */
package org.drools.brms.server.rules;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.base.ClassTypeResolver;
import org.drools.brms.client.modeldriven.SuggestionCompletionEngine;
import org.drools.brms.server.util.SuggestionCompletionEngineBuilder;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.ParserError;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.resource.util.ByteArrayClassLoader;
import org.drools.util.asm.ClassFieldInspector;

public class SuggestionCompletionLoader {
    private final SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();
    private final DrlParser parser = new DrlParser();
    private final ByteArrayClassLoader loader;
    protected List errors = new ArrayList();
    private ClassLoader existingLoader;

    public SuggestionCompletionLoader() {
        this.loader = new ByteArrayClassLoader(this.getClass().getClassLoader());
    }

    public SuggestionCompletionLoader(ClassLoader classLoader) {
        this();
        this.existingLoader = classLoader;
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List jars, List dsls) {
        this.builder.newCompletionEngine();
        if (!header.trim().equals("")) {
            this.processPackageHeader(header, jars);
        }
        this.populateDSLSentences(dsls);
        return this.builder.getInstance();
    }

    private void processPackageHeader(String header, List jars) {
        PackageDescr pkgDescr;
        try {
            pkgDescr = this.parser.parse(header);
        }
        catch (DroolsParserException e1) {
            throw new IllegalStateException("Serious error, unable to validate package.");
        }
        if (this.parser.hasErrors()) {
            Iterator iter = this.parser.getErrors().iterator();
            while (iter.hasNext()) {
                ParserError element = (ParserError)iter.next();
                this.errors.add(element.getMessage());
            }
        }
        this.populateModelInfo(pkgDescr, jars);
        this.populateGlobalInfo(pkgDescr, jars);
    }

    private void populateDSLSentences(List dsls) {
        Iterator it = dsls.iterator();
        while (it.hasNext()) {
            DSLMappingFile file = (DSLMappingFile)it.next();
            DSLMapping mapping = file.getMapping();
            Iterator entries = mapping.getEntries().iterator();
            while (entries.hasNext()) {
                DSLMappingEntry entry = (DSLMappingEntry)entries.next();
                if (entry.getSection() == DSLMappingEntry.CONDITION) {
                    this.builder.addDSLConditionSentence(entry.getMappingKey());
                    continue;
                }
                if (entry.getSection() != DSLMappingEntry.CONSEQUENCE) continue;
                this.builder.addDSLActionSentence(entry.getMappingKey());
            }
        }
    }

    private void populateGlobalInfo(PackageDescr pkgDescr, List jars) {
        Iterator it = pkgDescr.getGlobals().iterator();
        while (it.hasNext()) {
            GlobalDescr global = (GlobalDescr)it.next();
            try {
                String shortTypeName = global.getType();
                if (!this.builder.hasFieldsForType(shortTypeName)) {
                    Class clazz = this.loadClass(global.getType(), jars);
                    this.loadClassFields(clazz, shortTypeName);
                    this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
                }
                this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting class for global: " + global.getType() + " error message: " + e.getMessage());
            }
        }
    }

    private void populateModelInfo(PackageDescr pkgDescr, List jars) {
        ClassTypeResolver resolver = new ClassTypeResolver();
        Iterator it = pkgDescr.getImports().iterator();
        while (it.hasNext()) {
            ImportDescr imp = (ImportDescr)it.next();
            String classname = imp.getTarget();
            resolver.addImport(classname);
            Class clazz = this.loadClass(classname, jars);
            if (clazz == null) continue;
            try {
                String shortTypeName = this.getShortNameOfClass(clazz.getName());
                this.loadClassFields(clazz, shortTypeName);
                this.builder.addFactType(shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting the class: " + classname + ". The error was: " + e.getMessage());
            }
        }
        this.populateFactTemplateTypes(pkgDescr, resolver);
    }

    private void populateFactTemplateTypes(PackageDescr pkgDescr, ClassTypeResolver resolver) {
        Iterator it = pkgDescr.getFactTemplates().iterator();
        while (it.hasNext()) {
            FactTemplateDescr templ = (FactTemplateDescr)it.next();
            String factType = templ.getName();
            this.builder.addFactType(factType);
            String[] fields = new String[templ.getFields().size()];
            this.builder.addFieldsForType(factType, fields);
            int index = 0;
            Iterator fieldsIt = templ.getFields().iterator();
            while (fieldsIt.hasNext()) {
                FieldTemplateDescr fieldDescr = (FieldTemplateDescr)fieldsIt.next();
                fields[index++] = fieldDescr.getName();
                String fieldType = fieldDescr.getClassType();
                Class fieldTypeClass = null;
                try {
                    fieldTypeClass = resolver.resolveType(fieldType);
                }
                catch (ClassNotFoundException e) {
                    this.errors.add("Fact template field type not found: " + fieldType);
                }
                this.builder.addFieldType(factType + "." + fieldDescr.getName(), this.getFieldType(fieldTypeClass));
            }
        }
    }

    private void loadClassFields(Class clazz, String shortTypeName) throws IOException {
        if (clazz == null) {
            return;
        }
        ClassFieldInspector inspector = new ClassFieldInspector(clazz);
        String[] fields = inspector.getFieldNames().keySet().toArray(new String[inspector.getFieldNames().size()]);
        fields = this.removeIrrelevantFields(fields);
        this.builder.addFieldsForType(shortTypeName, fields);
        for (int i = 0; i < fields.length; ++i) {
            Class type = (Class)inspector.getFieldTypes().get(fields[i]);
            String fieldType = this.getFieldType(type);
            this.builder.addFieldType(shortTypeName + "." + fields[i], fieldType);
        }
    }

    String getShortNameOfClass(String clazz) {
        return clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    String[] removeIrrelevantFields(String[] fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (field.equals("class") || field.equals("hashCode") || field.equals("toString")) continue;
            result.add(field);
        }
        return result.toArray(new String[result.size()]);
    }

    private Class loadClass(String classname, List jars) {
        Class<?> clazz = null;
        try {
            clazz = this.existingLoader != null ? this.existingLoader.loadClass(classname) : this.loader.loadClass(classname);
        }
        catch (ClassNotFoundException e1) {
            try {
                this.addJars(jars);
                clazz = this.loader.loadClass(classname);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                this.errors.add("Class not found: " + classname);
            }
        }
        return clazz;
    }

    private void addJars(List jars) throws IOException {
        Iterator it = jars.iterator();
        while (it.hasNext()) {
            JarInputStream jis = (JarInputStream)it.next();
            JarEntry entry = null;
            byte[] buf = new byte[1024];
            int len = 0;
            while ((entry = jis.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = jis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                this.loader.addResource(entry.getName(), out.toByteArray());
            }
        }
    }

    private String getFieldType(Class type) {
        String fieldType = null;
        if (type != null) {
            if (type.isPrimitive() && type != Boolean.TYPE) {
                fieldType = "Numeric";
            } else if (Number.class.isAssignableFrom(type)) {
                fieldType = "Numeric";
            } else if (String.class.isAssignableFrom(type)) {
                fieldType = "String";
            } else if (Collection.class.isAssignableFrom(type)) {
                fieldType = "Collection";
            } else if (Comparable.class.isAssignableFrom(type)) {
                fieldType = "Comparable";
            }
        }
        return fieldType;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List getErrors() {
        return this.errors;
    }
}

