/*
 * Decompiled with CFR 0.152.
 */
package org.drools.brms.server.util;

import org.drools.brms.client.modeldriven.brxml.ActionAssertFact;
import org.drools.brms.client.modeldriven.brxml.ActionAssertLogicalFact;
import org.drools.brms.client.modeldriven.brxml.ActionFieldValue;
import org.drools.brms.client.modeldriven.brxml.ActionModifyField;
import org.drools.brms.client.modeldriven.brxml.ActionRetractFact;
import org.drools.brms.client.modeldriven.brxml.ActionSetField;
import org.drools.brms.client.modeldriven.brxml.CompositeFactPattern;
import org.drools.brms.client.modeldriven.brxml.ConnectiveConstraint;
import org.drools.brms.client.modeldriven.brxml.Constraint;
import org.drools.brms.client.modeldriven.brxml.DSLSentence;
import org.drools.brms.client.modeldriven.brxml.FactPattern;
import org.drools.brms.client.modeldriven.brxml.IAction;
import org.drools.brms.client.modeldriven.brxml.IPattern;
import org.drools.brms.client.modeldriven.brxml.RuleModel;
import org.drools.brms.server.util.BRLPersistence;
import org.drools.util.ReflectiveVisitor;

public class BRDRLPersistence
implements BRLPersistence {
    private static final BRLPersistence INSTANCE = new BRDRLPersistence();

    private BRDRLPersistence() {
    }

    public static BRLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(RuleModel model) {
        int i;
        boolean isDSLEnhanced = false;
        for (i = 0; !isDSLEnhanced && i < model.lhs.length; ++i) {
            if (!(model.lhs[i] instanceof DSLSentence)) continue;
            isDSLEnhanced = true;
        }
        for (i = 0; !isDSLEnhanced && i < model.rhs.length; ++i) {
            if (!(model.rhs[i] instanceof DSLSentence)) continue;
            isDSLEnhanced = true;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("rule \"" + model.name + "\"\n");
        this.marshalAttributes(buf, model);
        buf.append("\twhen\n");
        this.marshalLHS(buf, model, isDSLEnhanced);
        buf.append("\tthen\n");
        this.marshalRHS(buf, model, isDSLEnhanced);
        buf.append("end\n");
        return buf.toString();
    }

    public RuleModel unmarshal(String str) {
        throw new UnsupportedOperationException("Still not possible to convert pure DRL to RuleModel");
    }

    private void marshalAttributes(StringBuffer buf, RuleModel model) {
        for (int i = 0; i < model.attributes.length; ++i) {
            buf.append("\t");
            buf.append(model.attributes[i]);
            buf.append("\n");
        }
    }

    private void marshalLHS(StringBuffer buf, RuleModel model, boolean isDSLEnhanced) {
        IPattern[] lhs = model.lhs;
        LHSPatternVisitor visitor = new LHSPatternVisitor(isDSLEnhanced, buf);
        for (int i = 0; i < lhs.length; ++i) {
            IPattern cond = lhs[i];
            visitor.visit(cond);
        }
    }

    private void marshalRHS(StringBuffer buf, RuleModel model, boolean isDSLEnhanced) {
        IAction[] rhs = model.rhs;
        RHSActionVisitor visitor = new RHSActionVisitor(isDSLEnhanced, buf);
        for (int i = 0; i < rhs.length; ++i) {
            IAction action = rhs[i];
            visitor.visit(action);
        }
    }

    public static class RHSActionVisitor
    extends ReflectiveVisitor {
        private StringBuffer buf;
        private boolean isDSLEnhanced;
        private int idx = 0;

        public RHSActionVisitor(boolean isDSLEnhanced, StringBuffer b) {
            this.isDSLEnhanced = isDSLEnhanced;
            this.buf = b;
        }

        public void visitActionAssertFact(ActionAssertFact action) {
            this.generateAssertCall(action, false);
        }

        public void visitActionAssertLogicalFact(ActionAssertLogicalFact action) {
            this.generateAssertCall(action, false);
        }

        private void generateAssertCall(ActionAssertFact action, boolean isLogic) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (action.fieldValues.length == 0) {
                this.buf.append("assert( new ");
                this.buf.append(action.factType);
                this.buf.append("() );\n");
            } else {
                this.buf.append(action.factType);
                this.buf.append(" fact");
                this.buf.append(this.idx);
                this.buf.append(" = new ");
                this.buf.append(action.factType);
                this.buf.append("();\n");
                this.generateSetMethodCalls("fact" + this.idx, action.fieldValues);
                if (isLogic) {
                    this.buf.append("\t\tassertLogical( fact");
                } else {
                    this.buf.append("\t\tassert( fact");
                }
                this.buf.append(this.idx++);
                this.buf.append(" );\n");
            }
        }

        public void visitActionModifyField(ActionModifyField action) {
            this.visitActionSetField(action);
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append("modify( ");
            this.buf.append(action.variable);
            this.buf.append(" );\n");
        }

        public void visitActionRetractFact(ActionRetractFact action) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append("retract( ");
            this.buf.append(action.variableName);
            this.buf.append(" );\n");
        }

        public void visitDSLSentence(DSLSentence sentence) {
            this.buf.append("\t\t");
            this.buf.append(sentence.sentence);
            this.buf.append("\n");
        }

        public void visitActionSetField(ActionSetField action) {
            this.generateSetMethodCalls(action.variable, action.fieldValues);
        }

        private void generateSetMethodCalls(String variableName, ActionFieldValue[] fieldValues) {
            for (int i = 0; i < fieldValues.length; ++i) {
                this.buf.append("\t\t");
                if (this.isDSLEnhanced) {
                    this.buf.append(">");
                }
                this.buf.append(variableName);
                this.buf.append(".set");
                this.buf.append(Character.toUpperCase(fieldValues[i].field.charAt(0)));
                this.buf.append(fieldValues[i].field.substring(1));
                this.buf.append("( ");
                if (fieldValues[i].isFormula()) {
                    this.buf.append(fieldValues[i].value.substring(1));
                } else if ("String".equals(fieldValues[i].type)) {
                    this.buf.append("\"");
                    this.buf.append(fieldValues[i].value);
                    this.buf.append("\"");
                } else {
                    this.buf.append(fieldValues[i].value);
                }
                this.buf.append(" );\n");
            }
        }
    }

    public static class LHSPatternVisitor
    extends ReflectiveVisitor {
        private StringBuffer buf;
        private boolean isDSLEnhanced;

        public LHSPatternVisitor(boolean isDSLEnhanced, StringBuffer b) {
            this.isDSLEnhanced = isDSLEnhanced;
            this.buf = b;
        }

        public void visitFactPattern(FactPattern pattern) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.generateFactPattern(pattern);
            this.buf.append("\n");
        }

        public void visitCompositeFactPattern(CompositeFactPattern pattern) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if ("exists".equals(pattern.type)) {
                this.buf.append(pattern.type);
                this.buf.append(" ");
                this.generateFactPattern(pattern.patterns[0]);
                this.buf.append("\n");
            } else if ("not".equals(pattern.type)) {
                this.buf.append(pattern.type);
                this.buf.append(" ");
                this.generateFactPattern(pattern.patterns[0]);
                this.buf.append("\n");
            } else if ("or".equals(pattern.type)) {
                this.buf.append("( ");
                for (int i = 0; i < pattern.patterns.length; ++i) {
                    if (i > 0) {
                        this.buf.append(" ");
                        this.buf.append(pattern.type);
                        this.buf.append(" ");
                    }
                    this.generateFactPattern(pattern.patterns[0]);
                }
                this.buf.append(" )\n");
            }
        }

        public void visitDSLSentence(DSLSentence sentence) {
            this.buf.append("\t\t");
            this.buf.append(sentence.sentence);
            this.buf.append("\n");
        }

        private void generateFactPattern(FactPattern pattern) {
            if (pattern.boundName != null) {
                this.buf.append(pattern.boundName);
                this.buf.append(" : ");
            }
            if (pattern.factType != null) {
                this.buf.append(pattern.factType);
            }
            this.buf.append("( ");
            for (int i = 0; i < pattern.constraints.length; ++i) {
                if (i > 0) {
                    this.buf.append(", ");
                }
                Constraint constr = pattern.constraints[i];
                if (constr.constraintValueType == 5) {
                    this.buf.append("( ");
                    this.buf.append(constr.value);
                    this.buf.append(" )");
                    continue;
                }
                if (constr.fieldBinding != null) {
                    this.buf.append(constr.fieldBinding);
                    this.buf.append(" : ");
                }
                this.buf.append(constr.fieldName);
                this.addFieldRestriction(this.buf, constr.constraintValueType, constr.operator, constr.value);
                if (constr.connectives == null) continue;
                for (int j = 0; j < constr.connectives.length; ++j) {
                    ConnectiveConstraint conn = constr.connectives[j];
                    if (conn.isANDConnective()) {
                        this.buf.append("&");
                    } else if (conn.isORConnective()) {
                        this.buf.append("|");
                    } else {
                        throw new IllegalStateException("Unknown connective type/operator: [" + conn.operator + "]");
                    }
                    this.addFieldRestriction(this.buf, conn.constraintValueType, conn.operator, conn.value);
                }
            }
            this.buf.append(")");
        }

        private void addFieldRestriction(StringBuffer buf, int type, String operator, String value) {
            buf.append(" ");
            buf.append(operator);
            buf.append(" ");
            switch (type) {
                case 3: {
                    buf.append("( ");
                    buf.append(operator);
                    buf.append(" )");
                    break;
                }
                default: {
                    buf.append(value);
                }
            }
            buf.append(" ");
        }
    }
}

