/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jci.problems.CompilationProblem;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.compiler.DialectRegistry;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.FieldTemplateError;
import org.drools.compiler.FunctionError;
import org.drools.compiler.GlobalError;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageBuilderErrors;
import org.drools.compiler.ParserError;
import org.drools.compiler.RuleError;
import org.drools.facttemplates.FactTemplateImpl;
import org.drools.facttemplates.FieldTemplate;
import org.drools.facttemplates.FieldTemplateImpl;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.builder.Dialect;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleBuilder;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.SAXException;

public class PackageBuilder {
    private Package pkg;
    private List results;
    private PackageBuilderConfiguration configuration;
    private TypeResolver typeResolver;
    private ClassFieldExtractorCache classFieldExtractorCache;
    private RuleBuilder builder;
    private Dialect dialect;
    private DialectRegistry dialects;

    public PackageBuilder() {
        this(null, null);
    }

    public PackageBuilder(Package pkg) {
        this(pkg, null);
    }

    public PackageBuilder(PackageBuilderConfiguration configuration) {
        this(null, configuration);
    }

    public PackageBuilder(Package pkg, PackageBuilderConfiguration configuration) {
        if (configuration == null) {
            configuration = new PackageBuilderConfiguration();
        }
        this.configuration = configuration;
        this.results = new ArrayList();
        this.pkg = pkg;
        this.classFieldExtractorCache = new ClassFieldExtractorCache();
        this.dialects = new DialectRegistry();
        if (this.pkg != null) {
            this.typeResolver = new ClassTypeResolver(this.pkg.getImports(), this.pkg.getPackageCompilationData().getClassLoader());
            this.typeResolver.addImport(this.pkg.getName() + ".*");
            this.dialects.addDialect("java", new JavaDialect(pkg, configuration, this.getTypeResolver(), this.classFieldExtractorCache));
            this.dialect = this.dialects.getDialect("java");
        } else {
            this.typeResolver = new ClassTypeResolver(new ArrayList(), configuration.getClassLoader());
            this.dialects.addDialect("java", new JavaDialect(pkg, configuration, this.getTypeResolver(), this.classFieldExtractorCache));
            this.dialects.addDialect("default", this.dialects.getDialect(configuration.getDialect()));
            this.dialect = this.dialects.getDialect(configuration.getDialect());
        }
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(reader);
        this.results.addAll(parser.getErrors());
        this.addPackage(pkg);
    }

    public void addPackageFromXml(Reader reader) throws DroolsParserException, IOException {
        XmlPackageReader xmlReader = new XmlPackageReader();
        try {
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.toString(), e.getCause());
        }
        this.addPackage(xmlReader.getPackageDescr());
    }

    public void addPackageFromDrl(Reader source, Reader dsl) throws DroolsParserException, IOException {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(source, dsl);
        this.results.addAll(parser.getErrors());
        this.addPackage(pkg);
    }

    public void addPackage(PackageDescr packageDescr) {
        this.validatePackageName(packageDescr);
        this.validateUniqueRuleNames(packageDescr);
        if (this.pkg != null) {
            this.mergePackage(this.pkg, packageDescr);
        } else {
            this.pkg = this.newPackage(packageDescr);
        }
        this.builder = new RuleBuilder();
        if (!this.hasErrors()) {
            Iterator it = packageDescr.getFactTemplates().iterator();
            while (it.hasNext()) {
                this.addFactTemplate((FactTemplateDescr)it.next());
            }
            it = packageDescr.getFunctions().iterator();
            while (it.hasNext()) {
                this.addFunction((FunctionDescr)it.next());
            }
            it = packageDescr.getRules().iterator();
            while (it.hasNext()) {
                this.addRule((RuleDescr)it.next());
            }
        }
        this.dialect.compileAll();
        this.results.addAll(this.dialect.getResults());
    }

    private void validatePackageName(PackageDescr packageDescr) {
        if (this.pkg != null) {
            return;
        }
        if (packageDescr.getName() == null || "".equals(packageDescr.getName())) {
            throw new MissingPackageNameException("Missing package name for rule package.");
        }
    }

    private void validateUniqueRuleNames(PackageDescr packageDescr) {
        HashSet<String> names = new HashSet<String>();
        Iterator iter = packageDescr.getRules().iterator();
        while (iter.hasNext()) {
            RuleDescr rule = (RuleDescr)iter.next();
            String name = rule.getName();
            if (names.contains(name)) {
                this.results.add(new ParserError("Duplicate rule name: " + name, rule.getLine(), rule.getColumn()));
            }
            names.add(name);
        }
    }

    private Package newPackage(PackageDescr packageDescr) {
        Package pkg = new Package(packageDescr.getName(), this.configuration.getClassLoader());
        this.dialect = this.dialects.getDialect("java");
        this.dialect.init(pkg);
        this.mergePackage(pkg, packageDescr);
        return pkg;
    }

    private void mergePackage(Package pkg, PackageDescr packageDescr) {
        if (this.typeResolver.getImports().isEmpty()) {
            this.typeResolver.addImport(pkg.getName() + ".*");
        }
        List imports = packageDescr.getImports();
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String importEntry = ((ImportDescr)it.next()).getTarget();
            pkg.addImport(importEntry);
            this.typeResolver.addImport(importEntry);
        }
        it = packageDescr.getFunctionImports().iterator();
        while (it.hasNext()) {
            pkg.addStaticImport(((FunctionImportDescr)it.next()).getTarget());
        }
        ((ClassTypeResolver)this.typeResolver).setClassLoader(pkg.getPackageCompilationData().getClassLoader());
        List globals = packageDescr.getGlobals();
        Iterator it2 = globals.iterator();
        while (it2.hasNext()) {
            GlobalDescr global = (GlobalDescr)it2.next();
            String identifier = global.getIdentifier();
            String className = global.getType();
            try {
                Class clazz = this.typeResolver.resolveType(className);
                pkg.addGlobal(identifier, clazz);
            }
            catch (ClassNotFoundException e) {
                new GlobalError(identifier);
            }
        }
    }

    private void addFunction(FunctionDescr functionDescr) {
        this.dialect.addFunction(functionDescr, this.getTypeResolver());
    }

    private void addFactTemplate(FactTemplateDescr factTemplateDescr) {
        ArrayList<FieldTemplateImpl> fields = new ArrayList<FieldTemplateImpl>();
        int index = 0;
        Iterator it = factTemplateDescr.getFields().iterator();
        while (it.hasNext()) {
            FieldTemplateDescr fieldTemplateDescr = (FieldTemplateDescr)it.next();
            FieldTemplateImpl fieldTemplate = null;
            try {
                fieldTemplate = new FieldTemplateImpl(fieldTemplateDescr.getName(), index++, this.getTypeResolver().resolveType(fieldTemplateDescr.getClassType()));
            }
            catch (ClassNotFoundException e) {
                this.results.add(new FieldTemplateError(this.pkg, fieldTemplateDescr, null, "Unable to resolve Class '" + fieldTemplateDescr.getClassType() + "'"));
            }
            fields.add(fieldTemplate);
        }
        FactTemplateImpl factTemplate = new FactTemplateImpl(this.pkg, factTemplateDescr.getName(), fields.toArray(new FieldTemplate[fields.size()]));
    }

    private void addRule(RuleDescr ruleDescr) {
        RuleBuildContext context = new RuleBuildContext(this.pkg, ruleDescr, this.dialects);
        this.builder.build(context);
        this.results.addAll(context.getErrors());
        context.getDialect().addRule(context);
        this.pkg.addRule(context.getRule());
    }

    private TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public Package getPackage() {
        if (this.hasErrors()) {
            this.pkg.setError(this.getErrors().toString());
        }
        return this.pkg;
    }

    public boolean hasErrors() {
        return this.results.size() > 0;
    }

    public PackageBuilderErrors getErrors() {
        return new PackageBuilderErrors(this.results.toArray(new DroolsError[this.results.size()]));
    }

    protected void resetErrors() {
        this.results.clear();
    }

    public static class FunctionErrorHandler
    extends ErrorHandler {
        private FunctionDescr descr;

        public FunctionErrorHandler(FunctionDescr functionDescr, String message) {
            this.descr = functionDescr;
            this.message = message;
        }

        public DroolsError getError() {
            return new FunctionError(this.descr, this.collectCompilerProblems(), this.message);
        }
    }

    public static class RuleInvokerErrorHandler
    extends RuleErrorHandler {
        public RuleInvokerErrorHandler(BaseDescr ruleDescr, Rule rule, String message) {
            super(ruleDescr, rule, message);
        }
    }

    public static class RuleErrorHandler
    extends ErrorHandler {
        private BaseDescr descr;
        private Rule rule;

        public RuleErrorHandler(BaseDescr ruleDescr, Rule rule, String message) {
            this.descr = ruleDescr;
            this.rule = rule;
            this.message = message;
        }

        public DroolsError getError() {
            return new RuleError(this.rule, this.descr, this.collectCompilerProblems(), this.message);
        }
    }

    public static abstract class ErrorHandler {
        private final List errors = new ArrayList();
        protected String message;
        private boolean inError = false;

        public boolean isInError() {
            return this.inError;
        }

        public void addError(CompilationProblem err) {
            this.errors.add(err);
            this.inError = true;
        }

        public abstract DroolsError getError();

        protected CompilationProblem[] collectCompilerProblems() {
            if (this.errors.size() == 0) {
                return null;
            }
            CompilationProblem[] list = new CompilationProblem[this.errors.size()];
            this.errors.toArray(list);
            return list;
        }
    }

    public static class MissingPackageNameException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 320L;

        public MissingPackageNameException(String message) {
            super(message);
        }
    }
}

