/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.util.Arrays;
import org.drools.RuntimeDroolsException;

public class PackageBuilderConfiguration {
    public static final int ECLIPSE = 0;
    public static final int JANINO = 1;
    public static final String[] LANGUAGE_LEVELS = new String[]{"1.4", "1.5", "1.6"};
    public static final String DEFAULT_LANGUAGE_LEVEL = "1.4";
    private static final int CONFIGURED_COMPILER = PackageBuilderConfiguration.getDefaultCompiler();
    private static final String CONFIGURED_LANGUAGE_LEVEL = PackageBuilderConfiguration.getDefaultLanguageLevel();
    public static final String[] DIALECTS = new String[]{"java", "mvel"};
    private String dialect = PackageBuilderConfiguration.getDefaultDialect();
    private int compiler = CONFIGURED_COMPILER;
    private ClassLoader classLoader;
    private String languageLevel = CONFIGURED_LANGUAGE_LEVEL;

    public PackageBuilderConfiguration() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public int getCompiler() {
        return this.compiler;
    }

    public String getJavaLanguageLevel() {
        if (this.languageLevel != null) {
            return this.languageLevel;
        }
        this.setJavaLanguageLevel(System.getProperty("drools.compiler.lnglevel", DEFAULT_LANGUAGE_LEVEL));
        return this.languageLevel;
    }

    public void setJavaLanguageLevel(String level) {
        if (Arrays.binarySearch(LANGUAGE_LEVELS, this.languageLevel) < 0) {
            throw new RuntimeDroolsException("value '" + this.languageLevel + "' is not a valid language level");
        }
        this.languageLevel = level;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setCompiler(int compiler) {
        switch (compiler) {
            case 0: {
                this.compiler = 0;
                break;
            }
            case 1: {
                this.compiler = 1;
                break;
            }
            default: {
                throw new RuntimeDroolsException("value '" + compiler + "' is not a valid compiler");
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    static String getDefaultDialect() {
        String dialect = System.getProperty("drools.dialect", "java");
        if (Arrays.binarySearch(DIALECTS, dialect) < 0) {
            throw new RuntimeDroolsException(" dialect is not a valid registered dialect");
        }
        return dialect;
    }

    static int getDefaultCompiler() {
        try {
            String prop = System.getProperty("drools.compiler", "ECLIPSE");
            if (prop.equals("ECLIPSE".intern())) {
                return 0;
            }
            if (prop.equals("JANINO")) {
                return 1;
            }
            System.err.println("Drools config: unable to use the drools.compiler property. Using default. It was set to:" + prop);
            return 0;
        }
        catch (SecurityException e) {
            System.err.println("Drools config: unable to read the drools.compiler property. Using default.");
            return 0;
        }
    }

    static String getDefaultLanguageLevel() {
        try {
            String languageLevel = System.getProperty("drools.compiler.languagelevel", DEFAULT_LANGUAGE_LEVEL);
            if (Arrays.binarySearch(LANGUAGE_LEVELS, languageLevel) < 0) {
                throw new RuntimeDroolsException("value '" + languageLevel + "' is not a valid language level");
            }
            return languageLevel;
        }
        catch (Exception e) {
            System.err.println("Drools config: unable to read the drools.compiler.lnglevel property. Using default.");
            return DEFAULT_LANGUAGE_LEVEL;
        }
    }
}

