/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import com.thoughtworks.xstream.XStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.drools.ruleflow.common.core.IProcess;
import org.drools.ruleflow.core.IRuleFlowProcess;

public class ProcessBuilder {
    private final List processes = new ArrayList();

    public IProcess[] getProcesses() {
        return this.processes.toArray(new IProcess[this.processes.size()]);
    }

    public void addProcess(IProcess process) {
        this.processes.add(process);
    }

    public void addProcessFromFile(Reader reader) throws Exception {
        XStream stream = new XStream();
        stream.setMode(1002);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newLoader);
            IRuleFlowProcess process = (IRuleFlowProcess)stream.fromXML(reader);
            this.addProcess((IProcess)process);
        }
        catch (Exception t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        reader.close();
    }
}

