/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.Iterator;
import java.util.List;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PackageDescrDumper;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.util.ReflectiveVisitor;

public class DrlDumper
extends ReflectiveVisitor
implements PackageDescrDumper {
    private StringBuffer drlDump;
    private static final String eol = System.getProperty("line.separator");
    private String template;

    public synchronized String dump(PackageDescr packageDescr) {
        this.drlDump = new StringBuffer();
        this.visitPackageDescr(packageDescr);
        return this.drlDump.toString();
    }

    public void visitAndDescr(AndDescr descr) {
        this.template = new String();
        this.template = !descr.getDescrs().isEmpty() ? this.processDescrList(descr.getDescrs()) : "";
    }

    public void visitAttributeDescr(AttributeDescr attributeDescr) {
        this.template = new String();
        String name = attributeDescr.getName();
        String value = null;
        value = name.equals("agenda-group") || name.equals("activation-group") || name.equals("ruleflow-group") ? "\"" + attributeDescr.getValue() + "\"" : attributeDescr.getValue();
        this.template = "\t " + name + " " + value + eol;
    }

    public void visitFieldConstraintDescr(FieldConstraintDescr descr) {
        if (!descr.getRestrictions().isEmpty()) {
            this.template = descr.getFieldName() + " " + this.processFieldConstraint(descr.getRestrictions());
        }
    }

    public void visitVariableRestrictionDescr(VariableRestrictionDescr descr) {
        this.template = new String();
        this.template = descr.getEvaluator() + " " + descr.getIdentifier();
    }

    public void visitPatternDescr(PatternDescr descr) {
        this.template = new String();
        this.template = !descr.getDescrs().isEmpty() ? (descr.getIdentifier() != null ? "\t\t" + descr.getIdentifier() + " : " + descr.getObjectType() + "( " + this.processColoumnConstraintList(descr.getDescrs()) + ")" : "\t\t" + descr.getObjectType() + "( " + this.processColoumnConstraintList(descr.getDescrs()) + ")") : (descr.getIdentifier() != null ? "\t\t" + descr.getIdentifier() + " : " + descr.getObjectType() + "( )" : "\t\t" + descr.getObjectType() + "( )");
    }

    public void visitEvalDescr(EvalDescr descr) {
        this.template = new String();
        this.template = "\t\teval ( " + descr.getContent() + " )" + eol;
    }

    public void visitExistsDescr(ExistsDescr descr) {
        this.template = new String();
        this.template = !descr.getDescrs().isEmpty() ? "\t\texists " + this.processDescrList(descr.getDescrs()) : "";
    }

    public void visitFieldBindingDescr(FieldBindingDescr descr) {
        this.template = new String();
        this.template = descr.getIdentifier() + " : " + descr.getFieldName();
    }

    public void visitFunctionDescr(FunctionDescr functionDescr) {
        this.template = new String();
        String parameterTemplate = this.processParameters(functionDescr.getParameterNames(), functionDescr.getParameterTypes());
        this.template = "function " + functionDescr.getReturnType() + " " + functionDescr.getName() + "(" + parameterTemplate + "){" + functionDescr.getText() + eol + "}" + eol;
    }

    public void visitLiteralRestrictionDescr(LiteralRestrictionDescr descr) {
        this.template = new String();
        String text = descr.getText();
        if (text == null) {
            text = "null";
        } else {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                text = "\"" + text + "\"";
            }
        }
        this.template = descr.getEvaluator() + " " + text;
    }

    public void visitRestrictionConnectiveDescr(RestrictionConnectiveDescr descr) {
        this.template = descr.getConnective() == 1 ? " | " : " & ";
    }

    public void visitNotDescr(NotDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs().isEmpty() ? "\t   not " + this.processDescrList(descr.getDescrs()) : "";
    }

    public void visitOrDescr(OrDescr descr) {
        this.template = new String();
        this.template = !descr.getDescrs().isEmpty() ? this.processOrDescrList(descr.getDescrs()) : " ";
    }

    public void visitPackageDescr(PackageDescr packageDescr) {
        String packageName = packageDescr.getName();
        String xmlString = "package " + packageName + ";" + eol + eol;
        this.appendDrlDump(xmlString);
        if (packageDescr.getImports() != null) {
            this.appendDrlDump(this.processImportsList(packageDescr.getImports()));
        }
        if (packageDescr.getGlobals() != null) {
            this.appendDrlDump(this.processGlobalsList(packageDescr.getGlobals()));
        }
        if (packageDescr.getFunctions() != null) {
            this.appendDrlDump(this.processFunctionsList(packageDescr.getFunctions()));
        }
        if (packageDescr.getRules() != null) {
            this.appendDrlDump(this.processRules(packageDescr.getRules()));
        }
    }

    public void visitPredicateDescr(PredicateDescr descr) {
        this.template = new String();
        this.template = "( " + descr.getContent() + " )";
    }

    public void visitReturnValueRestrictionDescr(ReturnValueRestrictionDescr descr) {
        this.template = new String();
        this.template = descr.getEvaluator() + " ( " + descr.getContent() + ")";
    }

    public void visitQueryDescr(QueryDescr descr) {
        this.template = new String();
        this.template = "<query name=\"" + descr.getName() + "\">" + "<lhs>" + this.processDescrList(descr.getLhs().getDescrs()) + "</lhs>" + "</query>";
    }

    private String processRules(List rules) {
        String ruleList = "";
        Iterator iterator = rules.iterator();
        while (iterator.hasNext()) {
            RuleDescr ruleDescr = (RuleDescr)iterator.next();
            String rule = "rule \"" + ruleDescr.getName() + "\" " + eol;
            String attribute = this.processAttribute(ruleDescr.getAttributes());
            String lhs = "";
            lhs = !ruleDescr.getLhs().getDescrs().isEmpty() ? "\t when" + eol + this.processDescrList(ruleDescr.getLhs().getDescrs()) + eol : "\t when";
            String rhs = (String)ruleDescr.getConsequence();
            rhs = rhs == null ? "\t then" + eol + "\t" : "\t then" + eol + ruleDescr.getConsequence();
            rule = rule + attribute;
            rule = rule + lhs;
            rule = rule + rhs;
            rule = rule + "end" + eol;
            ruleList = ruleList + rule;
        }
        return ruleList + eol;
    }

    private String processOrDescrList(List descr) {
        String descrString = "";
        Iterator iterator = descr.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            descrString = descrString + this.template;
            if (descrString.endsWith(eol)) {
                descrString = descrString.substring(0, descrString.indexOf(eol));
            }
            descrString = descrString + " || ";
        }
        return descrString.substring(0, descrString.length() - 4);
    }

    private String processColoumnConstraintList(List descr) {
        String descrString = "";
        Object previous = null;
        Iterator iterator = descr.iterator();
        while (iterator.hasNext()) {
            Object temp = iterator.next();
            this.visit(temp);
            if (previous == null) {
                descrString = descrString + this.template;
            } else if (previous instanceof FieldBindingDescr && !(temp instanceof FieldBindingDescr) && !(temp instanceof PredicateDescr)) {
                FieldConstraintDescr tempDescr = (FieldConstraintDescr)temp;
                FieldBindingDescr previousDescr = previous;
                descrString = tempDescr.getFieldName().equals(previousDescr.getFieldName()) ? descrString + this.template.substring(tempDescr.getFieldName().length() + 1) : descrString + " , " + this.template;
            } else {
                descrString = descrString + " , " + this.template;
            }
            previous = temp;
        }
        return descrString.substring(0, descrString.length());
    }

    private String processFieldConstraint(List list) {
        String descrString = "";
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            this.visit(temp);
            descrString = descrString + this.template;
        }
        return descrString;
    }

    private String processDescrList(List descr) {
        String descrString = "";
        Iterator it = descr.iterator();
        while (it.hasNext()) {
            this.visit(it.next());
            descrString = descrString + this.template;
            descrString = descrString + eol;
        }
        return descrString;
    }

    private String processFunctionsList(List functions) {
        String functionList = "";
        Iterator it = functions.iterator();
        while (it.hasNext()) {
            this.visit(it.next());
            functionList = functionList + this.template;
        }
        return functionList + eol;
    }

    private String processAttribute(List attributes) {
        String attributeList = "";
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            AttributeDescr attributeDescr = (AttributeDescr)it.next();
            this.visit(attributeDescr);
            attributeList = attributeList + this.template;
        }
        return attributeList;
    }

    private String processParameters(List parameterNames, List parameterTypes) {
        if (parameterNames.isEmpty()) {
            return "";
        }
        String paramList = "";
        int i = 0;
        Iterator it = parameterNames.iterator();
        while (it.hasNext()) {
            String paramName = (String)it.next();
            String paramType = (String)parameterTypes.get(i);
            String paramTemplate = paramType + " " + paramName + ",";
            paramList = paramList + paramTemplate;
            ++i;
        }
        paramList = paramList.substring(0, paramList.length() - 1);
        return paramList;
    }

    private String processGlobalsList(List globals) {
        String globalList = "";
        Iterator it = globals.iterator();
        while (it.hasNext()) {
            GlobalDescr global = (GlobalDescr)it.next();
            String identifier = global.getIdentifier();
            String type = global.getType();
            String globalTemplate = "global " + type + " " + identifier + ";" + eol;
            globalList = globalList + globalTemplate;
        }
        return globalList + eol;
    }

    private String processImportsList(List imports) {
        String importList = "";
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String importString = ((ImportDescr)it.next()).getTarget();
            String importTemplate = "import " + importString + ";" + eol;
            importList = importList + importTemplate;
        }
        return importList + eol;
    }

    private void appendDrlDump(String temp) {
        this.drlDump.append(temp);
    }
}

