/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.lang.dsl.DSLMappingEntry;

public class DefaultDSLMappingEntry
implements DSLMappingEntry {
    private DSLMappingEntry.Section section;
    private DSLMappingEntry.MetaData metadata;
    private String key;
    private String value;
    private Map variables = Collections.EMPTY_MAP;
    private Pattern keyPattern;
    private String valuePattern;
    static final Pattern varFinder = Pattern.compile("(^|[^\\\\])\\{([(\\\\\\{)|[^\\{]]*?)\\}", 40);

    public DefaultDSLMappingEntry() {
        this(DSLMappingEntry.ANY, DSLMappingEntry.EMPTY_METADATA, null, null);
    }

    public DefaultDSLMappingEntry(DSLMappingEntry.Section section, DSLMappingEntry.MetaData metadata, String key, String value) {
        this.section = section;
        this.metadata = metadata;
        this.setMappingKey(key);
        this.setMappingValue(value);
    }

    public DSLMappingEntry.Section getSection() {
        return this.section;
    }

    public DSLMappingEntry.MetaData getMetaData() {
        return this.metadata;
    }

    public String getMappingKey() {
        return this.key;
    }

    public String getMappingValue() {
        return this.value;
    }

    public void setMappingKey(String key) {
        this.key = key;
        if (key != null) {
            int substr = 0;
            Matcher m = varFinder.matcher(key.replaceAll("\\$", "\\\\\\$"));
            StringBuffer buf = new StringBuffer();
            int counter = 1;
            if (!key.startsWith("^")) {
                buf.append("(\\W|^)");
                substr += buf.length();
                ++counter;
            }
            while (m.find()) {
                if (this.variables == Collections.EMPTY_MAP) {
                    this.variables = new HashMap(2);
                }
                this.variables.put(m.group(2), new Integer(counter++));
                m.appendReplacement(buf, m.group(1) + "(.*?)");
            }
            m.appendTail(buf);
            if (buf.toString().endsWith("(.*?)")) {
                buf.append("$");
            } else {
                buf.append("(\\W|$)");
            }
            String pat = buf.toString().replaceAll("\\s+", "\\\\s*");
            if (pat.substring(substr).trim().startsWith("-") && !pat.substring(substr).trim().startsWith("-\\s*")) {
                pat = pat.substring(0, pat.indexOf(45) + 1) + "\\s*" + pat.substring(pat.indexOf(45) + 1);
            }
            this.keyPattern = Pattern.compile(pat, 40);
        } else {
            this.keyPattern = null;
        }
        this.setMappingValue(this.value);
    }

    public void setSection(DSLMappingEntry.Section section) {
        this.section = section;
    }

    public void setMappingValue(String value) {
        this.valuePattern = value;
        this.value = value;
        if (value != null) {
            this.valuePattern = this.valuePattern.replaceAll("\\\\n", "\n").replaceAll("\\$", "\\\\\\$");
            Iterator it = this.variables.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String var = (String)entry.getKey();
                int pos = (Integer)entry.getValue();
                this.valuePattern = this.valuePattern.replaceAll("\\{" + var + "\\}", "\\$" + pos);
            }
        }
    }

    public void setMetaData(DSLMappingEntry.MetaData metadata) {
        this.metadata = metadata;
    }

    public Pattern getKeyPattern() {
        return this.keyPattern;
    }

    public String getValuePattern() {
        return this.valuePattern;
    }

    public Map getVariables() {
        return this.variables;
    }

    public String toPatternString() {
        return this.section + "[" + this.metadata + "]" + this.keyPattern.pattern() + "=" + this.valuePattern;
    }

    public String toString() {
        return this.section + "[" + this.metadata + "]" + this.key + "=" + this.value;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.section == null ? 0 : this.section.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultDSLMappingEntry other = (DefaultDSLMappingEntry)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.section == null ? other.section != null : !this.section.equals(other.section)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public List getErrors() {
        return Collections.EMPTY_LIST;
    }
}

