/*
 * Decompiled with CFR 0.152.
 */
package org.drools.resource.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ByteArrayClassLoader
extends ClassLoader {
    private final Map resources = new HashMap();

    public ByteArrayClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    public void addResource(String name, byte[] bytecode) {
        this.resources.put(name, bytecode);
    }

    public Class fastFindClass(String name) {
        byte[] clazzBytes;
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null && (clazzBytes = (byte[])this.resources.get(ByteArrayClassLoader.convertClassToResourcePath(name))) != null) {
            return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
        }
        return clazz;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.fastFindClass(name);
        if (clazz == null) {
            ClassLoader parent = this.getParent();
            if (parent != null) {
                clazz = parent.loadClass(name);
            } else {
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class clazz = this.fastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    public InputStream getResourceAsStream(String name) {
        byte[] bytes = (byte[])this.resources.get(name);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        InputStream input = this.getParent().getResourceAsStream(name);
        if (input == null) {
            input = super.getResourceAsStream(name);
        }
        return input;
    }

    private static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }
}

