/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.Iterator;
import org.drools.RuntimeDroolsException;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.rule.ConditionalElement;
import org.drools.rule.GroupElement;
import org.drools.rule.GroupElementFactory;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.ConditionalElementBuilder;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.RuleBuildContext;

public class GroupElementBuilder
implements ConditionalElementBuilder {
    public ConditionalElement build(RuleBuildContext context, BaseDescr descr) {
        ConditionalElementDescr cedescr = (ConditionalElementDescr)((Object)descr);
        GroupElement ge = this.newGroupElementFor(cedescr.getClass());
        context.getBuildStack().push(ge);
        Iterator it = cedescr.getDescrs().iterator();
        while (it.hasNext()) {
            BaseDescr child = (BaseDescr)it.next();
            Object builder = context.getDialect().getBuilder(child.getClass());
            if (builder instanceof ConditionalElementBuilder) {
                ConditionalElementBuilder ceBuilder = (ConditionalElementBuilder)builder;
                ConditionalElement ce = ceBuilder.build(context, child);
                if (ce == null) continue;
                ge.addChild((RuleConditionElement)ce);
                continue;
            }
            if (builder instanceof PatternBuilder) {
                PatternBuilder patternBuilder = (PatternBuilder)context.getDialect().getBuilder(child.getClass());
                Pattern pattern = patternBuilder.build(context, (PatternDescr)child);
                if (pattern == null) continue;
                ge.addChild((RuleConditionElement)pattern);
                continue;
            }
            throw new RuntimeDroolsException("BUG: no builder found for descriptor class " + child.getClass());
        }
        context.getBuildStack().pop();
        return ge;
    }

    private GroupElement newGroupElementFor(Class descr) {
        if (AndDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newAndInstance();
        }
        if (OrDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newOrInstance();
        }
        if (NotDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newNotInstance();
        }
        if (ExistsDescr.class.isAssignableFrom(descr)) {
            return GroupElementFactory.newExistsInstance();
        }
        throw new RuntimeDroolsException("BUG: Not able to create a group element for descriptor: " + descr.getName());
    }
}

