/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jci.utils.ClassUtils;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.base.FieldFactory;
import org.drools.base.ShadowProxyFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.compiler.RuleError;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateFieldExtractor;
import org.drools.facttemplates.FactTemplateObjectType;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.rule.AndCompositeRestriction;
import org.drools.rule.Declaration;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.LiteralRestriction;
import org.drools.rule.MultiRestrictionFieldConstraint;
import org.drools.rule.OrCompositeRestriction;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.VariableConstraint;
import org.drools.rule.VariableRestriction;
import org.drools.rule.builder.Dialect;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldExtractor;
import org.drools.spi.FieldValue;
import org.drools.spi.ObjectType;
import org.drools.spi.Restriction;

public class PatternBuilder {
    private Dialect dialect;

    public PatternBuilder(Dialect dialect) {
        this.dialect = dialect;
    }

    public Pattern build(RuleBuildContext context, PatternDescr patternDescr) {
        Pattern pattern;
        if (patternDescr.getObjectType() == null || patternDescr.getObjectType().equals("")) {
            context.getErrors().add(new RuleError(context.getRule(), patternDescr, null, "ObjectType not correctly defined"));
            return null;
        }
        FactTemplateObjectType objectType = null;
        FactTemplate factTemplate = context.getPkg().getFactTemplate(patternDescr.getObjectType());
        if (factTemplate != null) {
            objectType = new FactTemplateObjectType(factTemplate);
        } else {
            try {
                Class<?> shadowClass;
                Class userProvidedClass;
                block13: {
                    userProvidedClass = context.getDialect().getTypeResolver().resolveType(patternDescr.getObjectType());
                    String shadowProxyName = ShadowProxyFactory.getProxyClassNameForClass((Class)userProvidedClass);
                    shadowClass = null;
                    try {
                        shadowClass = context.getPkg().getPackageCompilationData().getClassLoader().loadClass(shadowProxyName);
                    }
                    catch (ClassNotFoundException cnfe) {
                        byte[] proxyBytes = ShadowProxyFactory.getProxyBytes((Class)userProvidedClass);
                        if (proxyBytes == null) break block13;
                        context.getPkg().getPackageCompilationData().write(ClassUtils.convertClassToResourcePath(shadowProxyName), proxyBytes);
                        shadowClass = context.getPkg().getPackageCompilationData().getClassLoader().loadClass(shadowProxyName);
                    }
                }
                objectType = new ClassObjectType(userProvidedClass, shadowClass);
            }
            catch (ClassNotFoundException e) {
                context.getErrors().add(new RuleError(context.getRule(), patternDescr, null, "Unable to resolve ObjectType '" + patternDescr.getObjectType() + "'"));
                return null;
            }
        }
        if (patternDescr.getIdentifier() != null && !patternDescr.getIdentifier().equals("")) {
            if (context.getDeclarationResolver().isDuplicated(patternDescr.getIdentifier())) {
                context.getErrors().add(new RuleError(context.getRule(), patternDescr, null, "Duplicate declaration for variable '" + patternDescr.getIdentifier() + "' in the rule '" + context.getRule().getName() + "'"));
            }
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, patternDescr.getIdentifier());
        } else {
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, null);
        }
        context.getBuildStack().push(pattern);
        Iterator it = patternDescr.getDescrs().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof FieldBindingDescr) {
                this.build(context, pattern, (FieldBindingDescr)object);
                continue;
            }
            if (object instanceof FieldConstraintDescr) {
                this.build(context, pattern, (FieldConstraintDescr)object);
                continue;
            }
            if (!(object instanceof PredicateDescr)) continue;
            this.build(context, pattern, (PredicateDescr)object);
        }
        context.getBuildStack().pop();
        return pattern;
    }

    private void build(RuleBuildContext context, Pattern pattern, FieldConstraintDescr fieldConstraintDescr) {
        FieldExtractor extractor = this.getFieldExtractor(context, fieldConstraintDescr, pattern.getObjectType(), fieldConstraintDescr.getFieldName(), true);
        if (extractor == null) {
            return;
        }
        if (fieldConstraintDescr.getRestrictions().size() == 1) {
            Object object = fieldConstraintDescr.getRestrictions().get(0);
            Restriction restriction = this.buildRestriction(context, pattern, extractor, fieldConstraintDescr, (RestrictionDescr)object);
            if (restriction == null) {
                return;
            }
            if (object instanceof LiteralRestrictionDescr) {
                pattern.addConstraint((Constraint)new LiteralConstraint(extractor, (LiteralRestriction)restriction));
            } else if (object instanceof VariableRestrictionDescr) {
                pattern.addConstraint((Constraint)new VariableConstraint(extractor, (VariableRestriction)restriction));
            } else if (object instanceof ReturnValueRestrictionDescr) {
                pattern.addConstraint((Constraint)new ReturnValueConstraint(extractor, (ReturnValueRestriction)restriction));
            }
            return;
        }
        ArrayList<Object> orList = new ArrayList<Object>();
        ArrayList<Restriction> andList = null;
        RestrictionDescr currentRestriction = null;
        RestrictionDescr previousRestriction = null;
        ArrayList<Object> currentList = null;
        ArrayList<Object> previousList = null;
        Iterator it = fieldConstraintDescr.getRestrictions().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof RestrictionConnectiveDescr) {
                if (((RestrictionConnectiveDescr)object).getConnective() == 0) {
                    if (andList == null) {
                        andList = new ArrayList<Restriction>();
                    }
                    previousList = currentList;
                    currentList = andList;
                } else {
                    previousList = currentList;
                    currentList = orList;
                }
            } else {
                Restriction restriction = null;
                if (currentList != null) {
                    if (previousList == null) {
                        restriction = this.buildRestriction(context, pattern, extractor, fieldConstraintDescr, previousRestriction);
                        if (currentList == andList) {
                            andList.add(restriction);
                        } else {
                            orList.add(restriction);
                        }
                    } else {
                        restriction = this.buildRestriction(context, pattern, extractor, fieldConstraintDescr, previousRestriction);
                        if (previousList == andList && currentList == orList) {
                            andList.add(restriction);
                            if (andList.size() == 1) {
                                orList.add(andList.get(0));
                            } else {
                                AndCompositeRestriction restrictions = new AndCompositeRestriction(andList.toArray(new Restriction[andList.size()]));
                                orList.add(restrictions);
                            }
                            andList = null;
                        } else if (previousList == andList && currentList == andList) {
                            andList.add(restriction);
                        } else if (previousList == orList && currentList == andList) {
                            andList.add(restriction);
                        } else if (previousList == orList && currentList == orList) {
                            orList.add(restriction);
                        }
                    }
                }
            }
            previousRestriction = currentRestriction;
            currentRestriction = (RestrictionDescr)object;
        }
        Restriction restriction = this.buildRestriction(context, pattern, extractor, fieldConstraintDescr, currentRestriction);
        currentList.add(restriction);
        OrCompositeRestriction restrictions = null;
        if (currentList == andList && !orList.isEmpty() && andList != null) {
            if (andList.size() == 1) {
                orList.add(andList.get(0));
            } else {
                orList.add(new AndCompositeRestriction(andList.toArray(new Restriction[andList.size()])));
            }
            andList = null;
        }
        if (!orList.isEmpty()) {
            restrictions = new OrCompositeRestriction(orList.toArray(new Restriction[orList.size()]));
        } else if (andList != null && !andList.isEmpty()) {
            restrictions = new AndCompositeRestriction(andList.toArray(new Restriction[andList.size()]));
        }
        pattern.addConstraint((Constraint)new MultiRestrictionFieldConstraint(extractor, restrictions));
    }

    private void build(RuleBuildContext context, Pattern pattern, FieldBindingDescr fieldBindingDescr) {
        if (context.getDeclarationResolver().isDuplicated(fieldBindingDescr.getIdentifier())) {
            context.getErrors().add(new RuleError(context.getRule(), fieldBindingDescr, null, "Duplicate declaration for variable '" + fieldBindingDescr.getIdentifier() + "' in the rule '" + context.getRule().getName() + "'"));
            return;
        }
        FieldExtractor extractor = this.getFieldExtractor(context, fieldBindingDescr, pattern.getObjectType(), fieldBindingDescr.getFieldName(), true);
        if (extractor == null) {
            return;
        }
        pattern.addDeclaration(fieldBindingDescr.getIdentifier(), (Extractor)extractor);
    }

    private void build(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr) {
        List[] usedIdentifiers = context.getDialect().getExpressionIdentifiers(context, predicateDescr, predicateDescr.getContent());
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        int size = usedIdentifiers[0].size();
        for (int i = 0; i < size; ++i) {
            Declaration decl = context.getDeclarationResolver().getDeclaration((String)usedIdentifiers[0].get(i));
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        int NOT_BOUND_INDEX = usedIdentifiers.length - 1;
        this.createImplicitBindings(context, pattern, usedIdentifiers[NOT_BOUND_INDEX], factDeclarations);
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        String[] requiredGlobals = usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]);
        PredicateConstraint predicateConstraint = new PredicateConstraint(null, previousDeclarations, localDeclarations, requiredGlobals);
        pattern.addConstraint((Constraint)predicateConstraint);
        PredicateBuilder builder = this.dialect.getPredicateBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, predicateConstraint, predicateDescr);
    }

    private void createImplicitBindings(RuleBuildContext context, Pattern pattern, List unboundIdentifiers, List factDeclarations) {
        int size = unboundIdentifiers.size();
        for (int i = 0; i < size; ++i) {
            String identifier = (String)unboundIdentifiers.get(i);
            FieldBindingDescr implicitBinding = new FieldBindingDescr(identifier, identifier);
            FieldExtractor extractor = this.getFieldExtractor(context, implicitBinding, pattern.getObjectType(), implicitBinding.getFieldName(), false);
            if (extractor == null) continue;
            Declaration declaration = new Declaration(identifier, (Extractor)extractor, pattern);
            factDeclarations.add(declaration);
        }
    }

    private Restriction buildRestriction(RuleBuildContext context, Pattern pattern, FieldExtractor extractor, FieldConstraintDescr fieldConstraintDescr, RestrictionDescr restrictionDescr) {
        LiteralRestriction restriction = null;
        if (restrictionDescr instanceof LiteralRestrictionDescr) {
            restriction = this.buildRestriction(context, extractor, fieldConstraintDescr, (LiteralRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof VariableRestrictionDescr) {
            restriction = this.buildRestriction(context, extractor, fieldConstraintDescr, (VariableRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof ReturnValueRestrictionDescr) {
            restriction = this.buildRestriction(context, pattern, extractor, fieldConstraintDescr, (ReturnValueRestrictionDescr)restrictionDescr);
        }
        return restriction;
    }

    private VariableRestriction buildRestriction(RuleBuildContext context, FieldExtractor extractor, FieldConstraintDescr fieldConstraintDescr, VariableRestrictionDescr variableRestrictionDescr) {
        if (variableRestrictionDescr.getIdentifier() == null || variableRestrictionDescr.getIdentifier().equals("")) {
            context.getErrors().add(new RuleError(context.getRule(), variableRestrictionDescr, null, "Identifier not defined for binding field '" + fieldConstraintDescr.getFieldName() + "'"));
            return null;
        }
        Declaration declaration = context.getDeclarationResolver().getDeclaration(variableRestrictionDescr.getIdentifier());
        if (declaration == null) {
            context.getErrors().add(new RuleError(context.getRule(), variableRestrictionDescr, null, "Unable to return Declaration for identifier '" + variableRestrictionDescr.getIdentifier() + "'"));
            return null;
        }
        Evaluator evaluator = this.getEvaluator(context, variableRestrictionDescr, extractor.getValueType(), variableRestrictionDescr.getEvaluator());
        if (evaluator == null) {
            return null;
        }
        return new VariableRestriction(extractor, declaration, evaluator);
    }

    private LiteralRestriction buildRestriction(RuleBuildContext context, FieldExtractor extractor, FieldConstraintDescr fieldConstraintDescr, LiteralRestrictionDescr literalRestrictionDescr) {
        FieldValue field = null;
        if (literalRestrictionDescr.isStaticFieldValue()) {
            int lastDot = literalRestrictionDescr.getText().lastIndexOf(46);
            String className = literalRestrictionDescr.getText().substring(0, lastDot);
            String fieldName = literalRestrictionDescr.getText().substring(lastDot + 1);
            try {
                Class staticClass = context.getDialect().getTypeResolver().resolveType(className);
                field = FieldFactory.getFieldValue((Object)staticClass.getField(fieldName).get(null), (ValueType)extractor.getValueType());
            }
            catch (ClassNotFoundException e) {
                context.getErrors().add(new RuleError(context.getRule(), literalRestrictionDescr, e, e.getMessage()));
            }
            catch (Exception e) {
                context.getErrors().add(new RuleError(context.getRule(), literalRestrictionDescr, e, "Unable to create a Field value of type  '" + extractor.getValueType() + "' and value '" + literalRestrictionDescr.getText() + "'"));
            }
        } else {
            try {
                field = FieldFactory.getFieldValue((String)literalRestrictionDescr.getText(), (ValueType)extractor.getValueType());
            }
            catch (Exception e) {
                context.getErrors().add(new RuleError(context.getRule(), literalRestrictionDescr, e, "Unable to create a Field value of type  '" + extractor.getValueType() + "' and value '" + literalRestrictionDescr.getText() + "'"));
            }
        }
        Evaluator evaluator = this.getEvaluator(context, literalRestrictionDescr, extractor.getValueType(), literalRestrictionDescr.getEvaluator());
        if (evaluator == null) {
            return null;
        }
        return new LiteralRestriction(field, evaluator, extractor);
    }

    private ReturnValueRestriction buildRestriction(RuleBuildContext context, Pattern pattern, FieldExtractor extractor, FieldConstraintDescr fieldConstraintDescr, ReturnValueRestrictionDescr returnValueRestrictionDescr) {
        List[] usedIdentifiers = context.getDialect().getExpressionIdentifiers(context, returnValueRestrictionDescr, returnValueRestrictionDescr.getContent());
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        int size = usedIdentifiers[0].size();
        for (int i = 0; i < size; ++i) {
            Declaration declaration = context.getDeclarationResolver().getDeclaration((String)usedIdentifiers[0].get(i));
            if (declaration.getPattern() == pattern) {
                factDeclarations.add(declaration);
                continue;
            }
            tupleDeclarations.add(declaration);
        }
        int NOT_BOUND_INDEX = usedIdentifiers.length - 1;
        this.createImplicitBindings(context, pattern, usedIdentifiers[NOT_BOUND_INDEX], factDeclarations);
        Evaluator evaluator = this.getEvaluator(context, returnValueRestrictionDescr, extractor.getValueType(), returnValueRestrictionDescr.getEvaluator());
        if (evaluator == null) {
            return null;
        }
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        String[] requiredGlobals = usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]);
        ReturnValueRestriction returnValueRestriction = new ReturnValueRestriction(extractor, previousDeclarations, localDeclarations, requiredGlobals, evaluator);
        ReturnValueBuilder builder = this.dialect.getReturnValueBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, returnValueRestriction, returnValueRestrictionDescr);
        return returnValueRestriction;
    }

    private FieldExtractor getFieldExtractor(RuleBuildContext context, BaseDescr descr, ObjectType objectType, String fieldName, boolean reportError) {
        FactTemplateFieldExtractor extractor;
        block4: {
            extractor = null;
            if (objectType.getValueType() == ValueType.FACTTEMPLATE_TYPE) {
                FactTemplate factTemplate = ((FactTemplateObjectType)objectType).getFactTemplate();
                extractor = new FactTemplateFieldExtractor(factTemplate, factTemplate.getFieldTemplateIndex(fieldName));
            } else {
                try {
                    ClassLoader classloader = context.getPkg().getPackageCompilationData().getClassLoader();
                    extractor = context.getDialect().getClassFieldExtractorCache().getExtractor(((ClassObjectType)objectType).getClassType(), fieldName, classloader);
                }
                catch (RuntimeDroolsException e) {
                    if (!reportError) break block4;
                    context.getErrors().add(new RuleError(context.getRule(), descr, (Object)e, "Unable to create Field Extractor for '" + fieldName + "'"));
                }
            }
        }
        return extractor;
    }

    private Evaluator getEvaluator(RuleBuildContext context, BaseDescr descr, ValueType valueType, String evaluatorString) {
        Evaluator evaluator = valueType.getEvaluator(Operator.determineOperator((String)evaluatorString));
        if (evaluator == null) {
            context.getErrors().add(new RuleError(context.getRule(), descr, null, "Unable to determine the Evaluator for  '" + valueType + "' and '" + evaluatorString + "'"));
        }
        return evaluator;
    }
}

