/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.rule.builder.dialect.java.parser.JavaParserLexer;
import org.drools.rule.builder.dialect.java.parser.JavaParserParser;

public class JavaExprAnalyzer {
    public List[] analyzeExpression(String expr, Set[] availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream(expr);
        JavaParserLexer lexer = new JavaParserLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParserParser parser = new JavaParserParser((TokenStream)tokenStream);
        parser.logicalOrExpression();
        return this.analyze(parser.getIdentifiers(), availableIdentifiers);
    }

    public List[] analyzeBlock(String expr, Set[] availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream("{" + expr + "}");
        JavaParserLexer lexer = new JavaParserLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParserParser parser = new JavaParserParser((TokenStream)tokenStream);
        parser.compoundStatement();
        return this.analyze(parser.getIdentifiers(), availableIdentifiers);
    }

    private List[] analyze(List identifiers, Set[] availableIdentifiers) throws RecognitionException {
        int i;
        HashSet notBound = new HashSet(identifiers);
        List[] used = new List[availableIdentifiers.length + 1];
        int length = used.length;
        for (i = 0; i < length - 1; ++i) {
            used[i] = new ArrayList();
        }
        length = availableIdentifiers.length;
        for (i = 0; i < length; ++i) {
            Set set = availableIdentifiers[i];
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String eachDecl = (String)it.next();
                if (!identifiers.contains(eachDecl)) continue;
                used[i].add(eachDecl);
                notBound.remove(eachDecl);
            }
        }
        used[used.length - 1] = new ArrayList(notBound);
        return used;
    }
}

