/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Iterator;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.util.StringUtils;

public class JavaRuleClassBuilder
implements RuleClassBuilder {
    public void buildRule(RuleBuildContext context, RuleDescr ruleDescr) {
        JavaDialect dialect = (JavaDialect)context.getDialect();
        if (context.getMethods().isEmpty()) {
            dialect.setRuleClass(null);
            return;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("package " + context.getPkg().getName() + ";" + lineSeparator);
        Iterator it = context.getPkg().getImports().iterator();
        while (it.hasNext()) {
            buffer.append("import " + it.next() + ";" + lineSeparator);
        }
        it = context.getPkg().getStaticImports().iterator();
        while (it.hasNext()) {
            buffer.append("import static " + it.next() + ";" + lineSeparator);
        }
        buffer.append("public class " + StringUtils.ucFirst((String)ruleDescr.getClassName()) + " {" + lineSeparator);
        buffer.append("    private static final long serialVersionUID  = 320L;" + lineSeparator);
        int size = context.getMethods().size() - 1;
        for (int i = 0; i < size; ++i) {
            buffer.append(context.getMethods().get(i) + lineSeparator);
        }
        String[] lines = buffer.toString().split(lineSeparator);
        ruleDescr.setConsequenceOffset(lines.length + 1);
        buffer.append(context.getMethods().get(context.getMethods().size() - 1) + lineSeparator);
        buffer.append("}");
        dialect.setRuleClass(buffer.toString());
    }
}

