/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.Configuration;
import org.drools.xml.Handler;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ReturnValueRestrictionHandler
extends BaseAbstractHandler
implements Handler {
    ReturnValueRestrictionHandler(XmlPackageReader xmlPackageReader) {
        this.xmlPackageReader = xmlPackageReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(FieldConstraintDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(LiteralRestrictionDescr.class);
            this.validPeers.add(ReturnValueRestrictionDescr.class);
            this.validPeers.add(VariableRestrictionDescr.class);
            this.validPeers.add(RestrictionConnectiveDescr.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.xmlPackageReader.startConfiguration(localName, attrs);
        String evaluator = attrs.getValue("evaluator");
        if (evaluator == null || evaluator.trim().equals("")) {
            throw new SAXParseException("<return-value-restriction> requires an 'evaluator' attribute", this.xmlPackageReader.getLocator());
        }
        ReturnValueRestrictionDescr returnValueDescr = new ReturnValueRestrictionDescr(evaluator);
        return returnValueDescr;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.xmlPackageReader.endConfiguration();
        ReturnValueRestrictionDescr returnValueDescr = (ReturnValueRestrictionDescr)this.xmlPackageReader.getCurrent();
        String expression = config.getText();
        if (expression == null || expression.trim().equals("")) {
            throw new SAXParseException("<return-value-restriction> must have some content", this.xmlPackageReader.getLocator());
        }
        returnValueDescr.setContent(expression);
        LinkedList parents = this.xmlPackageReader.getParents();
        ListIterator it = parents.listIterator(parents.size());
        it.previous();
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)it.previous();
        fieldConstraintDescr.addRestriction(returnValueDescr);
        return null;
    }

    public Class generateNodeFor() {
        return ReturnValueRestrictionDescr.class;
    }
}

