/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.Configuration;
import org.drools.xml.Handler;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class VariableRestrictionsHandler
extends BaseAbstractHandler
implements Handler {
    VariableRestrictionsHandler(XmlPackageReader xmlPackageReader) {
        this.xmlPackageReader = xmlPackageReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(FieldConstraintDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(LiteralRestrictionDescr.class);
            this.validPeers.add(ReturnValueRestrictionDescr.class);
            this.validPeers.add(VariableRestrictionDescr.class);
            this.validPeers.add(RestrictionConnectiveDescr.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.xmlPackageReader.startConfiguration(localName, attrs);
        String evaluator = attrs.getValue("evaluator");
        if (evaluator == null || evaluator.trim().equals("")) {
            throw new SAXParseException("<bound-variable> requires an 'evaluator' attribute", this.xmlPackageReader.getLocator());
        }
        String identifier = attrs.getValue("identifier");
        if (identifier == null || identifier.trim().equals("")) {
            throw new SAXParseException("<bound-variable>  requires an 'identifier' attribute", this.xmlPackageReader.getLocator());
        }
        VariableRestrictionDescr variableDescr = new VariableRestrictionDescr(evaluator, identifier);
        return variableDescr;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.xmlPackageReader.endConfiguration();
        VariableRestrictionDescr variableDescr = (VariableRestrictionDescr)this.xmlPackageReader.getCurrent();
        LinkedList parents = this.xmlPackageReader.getParents();
        ListIterator it = parents.listIterator(parents.size());
        it.previous();
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)it.previous();
        fieldConstraintDescr.addRestriction(variableDescr);
        return null;
    }

    public Class generateNodeFor() {
        return VariableRestrictionDescr.class;
    }
}

