/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.FunctionMapper;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.impl.ExpressionEvaluatorImpl;

public class JbpmExpressionEvaluator {
    static ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();
    static VariableResolver variableResolver = null;
    static FunctionMapper functionMapper = null;

    public static void setVariableResolver(VariableResolver variableResolver) {
        JbpmExpressionEvaluator.variableResolver = variableResolver;
    }

    public static void setFunctionMapper(FunctionMapper functionMapper) {
        JbpmExpressionEvaluator.functionMapper = functionMapper;
    }

    public static Object evaluate(String expression, ExecutionContext executionContext) {
        return JbpmExpressionEvaluator.evaluate(expression, executionContext, JbpmExpressionEvaluator.getUsedVariableResolver(), JbpmExpressionEvaluator.getUsedFunctionMapper());
    }

    public static Object evaluate(String expression, ExecutionContext executionContext, VariableResolver usedVariableResolver, FunctionMapper functionMapper) {
        Object result = null;
        ExecutionContext.pushCurrentContext(executionContext);
        try {
            String dollarExpression = JbpmExpressionEvaluator.translateExpressionToDollars(expression);
            result = evaluator.evaluate(dollarExpression, Object.class, usedVariableResolver, functionMapper);
        }
        catch (ELException e) {
            throw new JbpmException("couldn't evaluate expression '" + expression + "'", e.getRootCause() != null ? e.getRootCause() : e);
        }
        finally {
            ExecutionContext.popCurrentContext(executionContext);
        }
        return result;
    }

    static String translateExpressionToDollars(String expression) {
        char[] chars = expression.toCharArray();
        int index = 0;
        while (index != -1) {
            if ((index = expression.indexOf("#{", index)) == -1) continue;
            chars[index] = 36;
            ++index;
        }
        return new String(chars);
    }

    public static VariableResolver getUsedVariableResolver() {
        if (variableResolver != null) {
            return variableResolver;
        }
        return (VariableResolver)JbpmConfiguration.Configs.getObject("jbpm.variable.resolver");
    }

    public static FunctionMapper getUsedFunctionMapper() {
        if (functionMapper != null) {
            return functionMapper;
        }
        if (JbpmConfiguration.Configs.hasObject("jbpm.function.mapper")) {
            return (FunctionMapper)JbpmConfiguration.Configs.getObject("jbpm.function.mapper");
        }
        return null;
    }
}

