/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.BizManager;
import jp.sourceforge.kuzumeji.entity.ContractManager;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.Biz;
import jp.sourceforge.kuzumeji.entity.common.Contract;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.event.ActivityCheck;
import jp.sourceforge.kuzumeji.entity.event.Do;
import jp.sourceforge.kuzumeji.entity.event.Plan;
import jp.sourceforge.kuzumeji.entity.resource.Company;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import jp.sourceforge.kuzumeji.entity.resource.Unit;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="activity", schema="e", uniqueConstraints={@UniqueConstraint(columnNames={"no"})})
@EntityListeners(value={EntityListenerCallback.class})
public class Activity
implements Serializable,
Cloneable,
HistoryManager,
ContractManager,
BizManager {
    private static final long serialVersionUID = 1036855331852876944L;
    private Long id;
    private String cat;
    private String sts;
    private Company company;
    private String project;
    private String phase;
    private String no;
    private String alias;
    private String name;
    private String digest;
    private Person salesman;
    private Person leader;
    private Unit unit;
    private Biz biz;
    private Date startYmd;
    private Date endYmd;
    private Contract contract;
    private Double riskRate = 1.0;
    private String note;
    private Long verno;
    private History history;
    private List<ActivityCheck> activityChecks = new ArrayList<ActivityCheck>(0);
    private List<Plan> plans = new ArrayList<Plan>(0);
    private List<Do> dos = new ArrayList<Do>(0);

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="company_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company aCompany) {
        this.company = aCompany;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="salesman_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Person getSalesman() {
        return this.salesman;
    }

    public void setSalesman(Person aSalesman) {
        this.salesman = aSalesman;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="leader_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Person getLeader() {
        return this.leader;
    }

    public void setLeader(Person aLeader) {
        this.leader = aLeader;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="unit_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit aUnit) {
        this.unit = aUnit;
    }

    @Override
    @Embedded
    public Biz getBiz() {
        return this.biz;
    }

    @Override
    public void setBiz(Biz aBiz) {
        this.biz = aBiz;
    }

    @Column(name="cat", unique=false, nullable=false, insertable=true, updatable=true)
    public String getCat() {
        return this.cat;
    }

    public void setCat(String aCat) {
        this.cat = aCat;
    }

    @Column(name="no", unique=true, nullable=false, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    public String getNo() {
        return this.no;
    }

    public void setNo(String aNo) {
        this.no = aNo;
    }

    @Column(name="project", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getProject() {
        return this.project;
    }

    public void setProject(String aProject) {
        this.project = aProject;
    }

    @Column(name="phase", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String aPhase) {
        this.phase = aPhase;
    }

    @Column(name="alias", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String aAlias) {
        this.alias = aAlias;
    }

    @Column(name="name", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Column(name="digest", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String aDigest) {
        this.digest = aDigest;
    }

    @Column(name="sts", unique=false, nullable=true, insertable=true, updatable=true)
    public String getSts() {
        return this.sts;
    }

    public void setSts(String aSts) {
        this.sts = aSts;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="start_ymd", unique=false, nullable=true, insertable=true, updatable=true)
    public Date getStartYmd() {
        return this.startYmd;
    }

    public void setStartYmd(Date aStartYmd) {
        this.startYmd = aStartYmd;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="end_ymd", unique=false, nullable=true, insertable=true, updatable=true)
    public Date getEndYmd() {
        return this.endYmd;
    }

    public void setEndYmd(Date aEnd) {
        this.endYmd = aEnd;
    }

    @Override
    @Embedded
    public Contract getContract() {
        return this.contract;
    }

    @Override
    public void setContract(Contract aContract) {
        this.contract = aContract;
    }

    @Column(name="risk_rate", unique=false, nullable=false, insertable=true, updatable=true, precision=8, scale=0)
    public Double getRiskRate() {
        return this.riskRate;
    }

    public void setRiskRate(Double aRiskRate) {
        this.riskRate = aRiskRate;
    }

    @Column(name="note", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=1000, message="\u6700\u59271000\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getNote() {
        return this.note;
    }

    public void setNote(String aNote) {
        this.note = aNote;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Override
    @Embedded
    public History getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="activity")
    public List<ActivityCheck> getActivityChecks() {
        return this.activityChecks;
    }

    public void setActivityChecks(List<ActivityCheck> aActivityChecks) {
        this.activityChecks = aActivityChecks;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="activity")
    public List<Plan> getPlans() {
        return this.plans;
    }

    public void setPlans(List<Plan> aPlans) {
        this.plans = aPlans;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="activity")
    public List<Do> getDos() {
        return this.dos;
    }

    public void setDos(List<Do> aDos) {
        this.dos = aDos;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

