/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.event.Activity;
import jp.sourceforge.kuzumeji.entity.event.DoExpense;
import jp.sourceforge.kuzumeji.entity.event.DoTime;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="do", schema="e", uniqueConstraints={@UniqueConstraint(columnNames={"activity_no", "ym", "person_no"})})
@EntityListeners(value={EntityListenerCallback.class})
public class Do
implements Serializable,
Cloneable,
HistoryManager {
    private static final long serialVersionUID = 2080877769423615703L;
    private Long id;
    private Activity activity;
    private Date ym;
    private Person person;
    private Long verno;
    private History history;
    private List<DoTime> doTimes = new ArrayList<DoTime>(0);
    private List<DoExpense> doExpenses = new ArrayList<DoExpense>(0);
    private boolean confirmTime = false;
    private boolean confirmExpense = false;
    private boolean confirmProject = false;
    private boolean confirmPartner = false;
    private String checkTimeSts;
    private String checkExpenseSts;
    private Date confirmTimeDate;
    private Date confirmExpenseDate;
    private Date confirmProjectDate;
    private Date confirmPartnerDate;
    private Date rejectTimeDate;
    private Date rejectExpenseDate;
    private boolean marked;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="activity_no", referencedColumnName="no", unique=false, nullable=false, insertable=true, updatable=true)
    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity aActivity) {
        this.activity = aActivity;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ym", unique=false, nullable=false, insertable=true, updatable=true)
    public Date getYm() {
        return this.ym;
    }

    public void setYm(Date aWorkPeriod) {
        this.ym = aWorkPeriod;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="person_no", referencedColumnName="no", unique=false, nullable=false, insertable=true, updatable=true)
    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person aPerson) {
        this.person = aPerson;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Override
    @Embedded
    public History getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="doit")
    public List<DoTime> getDoTimes() {
        return this.doTimes;
    }

    public void setDoTimes(List<DoTime> aDoTimes) {
        this.doTimes = aDoTimes;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="doit")
    public List<DoExpense> getDoExpenses() {
        return this.doExpenses;
    }

    public void setDoExpenses(List<DoExpense> aDoExpenses) {
        this.doExpenses = aDoExpenses;
    }

    @Column(name="commit_time", unique=false, nullable=false, insertable=true, updatable=true)
    public boolean isConfirmTime() {
        return this.confirmTime;
    }

    public void setConfirmTime(boolean aCommitTime) {
        this.confirmTime = aCommitTime;
    }

    @Column(name="commit_expense", unique=false, nullable=false, insertable=true, updatable=true)
    public boolean isConfirmExpense() {
        return this.confirmExpense;
    }

    public void setConfirmExpense(boolean aCommitExpense) {
        this.confirmExpense = aCommitExpense;
    }

    @Column(name="commit_project", unique=false, nullable=false, insertable=true, updatable=true)
    public boolean isConfirmProject() {
        return this.confirmProject;
    }

    public void setConfirmProject(boolean aCommitProject) {
        this.confirmProject = aCommitProject;
    }

    @Column(name="commit_partner", unique=false, nullable=false, insertable=true, updatable=true)
    public boolean isConfirmPartner() {
        return this.confirmPartner;
    }

    public void setConfirmPartner(boolean aCommitPartner) {
        this.confirmPartner = aCommitPartner;
    }

    @Column(name="check_time_sts", unique=false, nullable=true, insertable=true, updatable=true)
    public String getCheckTimeSts() {
        return this.checkTimeSts;
    }

    public void setCheckTimeSts(String aCheckTimeSts) {
        this.checkTimeSts = aCheckTimeSts;
    }

    @Column(name="check_expense_sts", unique=false, nullable=true, insertable=true, updatable=true)
    public String getCheckExpenseSts() {
        return this.checkExpenseSts;
    }

    public void setCheckExpenseSts(String aCheckExpenseSts) {
        this.checkExpenseSts = aCheckExpenseSts;
    }

    @Column(name="confirm_time_date", unique=false, nullable=true, insertable=true, updatable=true)
    public Date getConfirmTimeDate() {
        return this.confirmTimeDate;
    }

    public void setConfirmTimeDate(Date aConfirmTimeDate) {
        this.confirmTimeDate = aConfirmTimeDate;
    }

    @Column(name="confirm_expense_date", unique=false, nullable=true, insertable=true, updatable=true)
    public Date getConfirmExpenseDate() {
        return this.confirmExpenseDate;
    }

    public void setConfirmExpenseDate(Date aConfirmExpenseDate) {
        this.confirmExpenseDate = aConfirmExpenseDate;
    }

    @Column(name="confirm_project_date", unique=false, nullable=true, insertable=true, updatable=true)
    public Date getConfirmProjectDate() {
        return this.confirmProjectDate;
    }

    public void setConfirmProjectDate(Date aConfirmProjectDate) {
        this.confirmProjectDate = aConfirmProjectDate;
    }

    @Column(name="confirm_partner_date", unique=false, nullable=true, insertable=true, updatable=true)
    public Date getConfirmPartnerDate() {
        return this.confirmPartnerDate;
    }

    public void setConfirmPartnerDate(Date aConfirmPartnerDate) {
        this.confirmPartnerDate = aConfirmPartnerDate;
    }

    @Column(name="reject_time_date", unique=false, nullable=true, insertable=true, updatable=true)
    public Date getRejectTimeDate() {
        return this.rejectTimeDate;
    }

    public void setRejectTimeDate(Date aRejectTimeDate) {
        this.rejectTimeDate = aRejectTimeDate;
    }

    @Column(name="reject_expense_date", unique=false, nullable=true, insertable=true, updatable=true)
    public Date getRejectExpenseDate() {
        return this.rejectExpenseDate;
    }

    public void setRejectExpenseDate(Date aRejectExpenseDate) {
        this.rejectExpenseDate = aRejectExpenseDate;
    }

    @Transient
    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean aMarked) {
        this.marked = aMarked;
    }

    @Transient
    public boolean isCanApproveTime() {
        String sts = this.getCheckTimeSts();
        if (sts == null) {
            return false;
        }
        if (sts.equals("\u672a\u627f\u8a8d")) {
            return true;
        }
        if (sts.equals("PM\u627f\u8a8d")) {
            return true;
        }
        if (sts.equals("LM\u627f\u8a8d")) {
            return true;
        }
        if (sts.equals("\u7d4c\u7406\u627f\u8a8d")) {
            return false;
        }
        if (sts.equals("\u5dee\u623b")) {
            return false;
        }
        return false;
    }

    @Transient
    public boolean isCanApproveExpense() {
        String sts = this.getCheckExpenseSts();
        if (sts == null) {
            return false;
        }
        if (sts.equals("\u672a\u627f\u8a8d")) {
            return true;
        }
        if (sts.equals("PM\u627f\u8a8d")) {
            return true;
        }
        if (sts.equals("LM\u627f\u8a8d")) {
            return true;
        }
        if (sts.equals("\u7d4c\u7406\u627f\u8a8d")) {
            return false;
        }
        if (sts.equals("\u5dee\u623b")) {
            return false;
        }
        return false;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

