/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.event;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.DailyProperty;
import jp.sourceforge.kuzumeji.entity.common.DailyTimestampI;
import jp.sourceforge.kuzumeji.entity.common.DailyTimestampO;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

@Entity
@Table(name="do_timecard", schema="e", uniqueConstraints={@UniqueConstraint(columnNames={"ym", "person_no"})})
@EntityListeners(value={EntityListenerCallback.class})
public class DoTimecard
implements Serializable,
Cloneable,
HistoryManager {
    private static final long serialVersionUID = 801777598465565202L;
    private Long id;
    private Date ym;
    private Person person;
    private DailyTimestampI inTime;
    private DailyTimestampO outTime;
    private DailyProperty prop;
    private Long verno;
    private History history;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ym", unique=false, nullable=false, insertable=true, updatable=true)
    public Date getYm() {
        return this.ym;
    }

    public void setYm(Date aWorkPeriod) {
        this.ym = aWorkPeriod;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="person_no", referencedColumnName="no", unique=false, nullable=false, insertable=true, updatable=true)
    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person aPerson) {
        this.person = aPerson;
    }

    @Embedded
    public DailyTimestampI getInTime() {
        return this.inTime;
    }

    public void setInTime(DailyTimestampI aInTime) {
        this.inTime = aInTime;
    }

    @Embedded
    public DailyTimestampO getOutTime() {
        return this.outTime;
    }

    public void setOutTime(DailyTimestampO aOutTime) {
        this.outTime = aOutTime;
    }

    @Embedded
    public DailyProperty getProp() {
        return this.prop;
    }

    public void setProp(DailyProperty aProp) {
        this.prop = aProp;
    }

    @Transient
    public void prepareProperty() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, this.getYm().getYear() + 1900);
        c.set(2, this.getYm().getMonth());
        c.set(5, 1);
        DailyProperty p = new DailyProperty();
        p.setP01(this.getProperty(c));
        p.setP02(this.getProperty(c));
        p.setP03(this.getProperty(c));
        p.setP04(this.getProperty(c));
        p.setP05(this.getProperty(c));
        p.setP06(this.getProperty(c));
        p.setP07(this.getProperty(c));
        p.setP08(this.getProperty(c));
        p.setP09(this.getProperty(c));
        p.setP10(this.getProperty(c));
        p.setP11(this.getProperty(c));
        p.setP12(this.getProperty(c));
        p.setP13(this.getProperty(c));
        p.setP14(this.getProperty(c));
        p.setP15(this.getProperty(c));
        p.setP16(this.getProperty(c));
        p.setP17(this.getProperty(c));
        p.setP18(this.getProperty(c));
        p.setP19(this.getProperty(c));
        p.setP20(this.getProperty(c));
        p.setP21(this.getProperty(c));
        p.setP22(this.getProperty(c));
        p.setP23(this.getProperty(c));
        p.setP24(this.getProperty(c));
        p.setP25(this.getProperty(c));
        p.setP26(this.getProperty(c));
        p.setP27(this.getProperty(c));
        p.setP28(this.getProperty(c));
        p.setP29(this.getProperty(c));
        p.setP30(this.getProperty(c));
        p.setP31(this.getProperty(c));
        this.setProp(p);
    }

    private String getProperty(Calendar cal) {
        int m = this.getYm().getMonth();
        String p = null;
        if (m != cal.get(2)) {
            p = "\u5916";
        }
        if (p == null) {
            int w = cal.get(7);
            if (w == 1) {
                p = "\u65e5";
            } else if (w == 7) {
                p = "\u571f";
            }
        }
        cal.add(5, 1);
        return p;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Embedded
    public History getHistory() {
        return this.history;
    }

    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

