/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.common.MonthlyCashflow;
import jp.sourceforge.kuzumeji.entity.common.MonthlyHeader;
import jp.sourceforge.kuzumeji.entity.common.MonthlyProfitLoss;
import jp.sourceforge.kuzumeji.entity.event.Activity;
import jp.sourceforge.kuzumeji.entity.event.PlanCashflow;
import jp.sourceforge.kuzumeji.entity.event.PlanExpense;
import jp.sourceforge.kuzumeji.entity.event.PlanPerson;
import jp.sourceforge.kuzumeji.entity.event.SalesProject;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="plan", schema="e", uniqueConstraints={@UniqueConstraint(columnNames={"activity_no", "cat"})})
@EntityListeners(value={EntityListenerCallback.class})
public class Plan
implements Serializable,
Cloneable,
HistoryManager {
    private static final long serialVersionUID = -226896359469557653L;
    private Long id;
    private Activity activity;
    private String cat = "\u6a21\u64ec";
    private String priceCat = "\u4eba\u6708";
    private String note;
    private Long verno;
    private History history;
    private List<PlanPerson> persons = new ArrayList<PlanPerson>(0);
    private List<PlanExpense> expenses = new ArrayList<PlanExpense>(0);
    private PlanCashflow cashflow;
    private SalesProject sales;
    private MonthlyHeader header;
    private List<MonthlyProfitLoss> pls;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="activity_no", referencedColumnName="no", unique=false, nullable=false, insertable=true, updatable=true)
    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity aActivity) {
        this.activity = aActivity;
    }

    @Column(name="cat", unique=false, nullable=false, insertable=true, updatable=true)
    public String getCat() {
        return this.cat;
    }

    public void setCat(String aPlanType) {
        this.cat = aPlanType;
    }

    @Column(name="price_cat", unique=false, nullable=false, insertable=true, updatable=true)
    public String getPriceCat() {
        return this.priceCat;
    }

    public void setPriceCat(String aPriceCat) {
        this.priceCat = aPriceCat;
    }

    @Column(name="note", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=1000, message="\u6700\u59271000\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getNote() {
        return this.note;
    }

    public void setNote(String aNote) {
        this.note = aNote;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Override
    @Embedded
    public History getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="plan")
    public List<PlanPerson> getPersons() {
        return this.persons;
    }

    public void setPersons(List<PlanPerson> aPlanPersons) {
        this.persons = aPlanPersons;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="plan")
    public List<PlanExpense> getExpenses() {
        return this.expenses;
    }

    public void setExpenses(List<PlanExpense> aPlanPersonCosts) {
        this.expenses = aPlanPersonCosts;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="plan_cashflow_id", referencedColumnName="id", unique=false, nullable=true, insertable=true, updatable=true)
    public PlanCashflow getCashflow() {
        return this.cashflow;
    }

    public void setCashflow(PlanCashflow aPlanCashflow) {
        this.cashflow = aPlanCashflow;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="sales_project_id", referencedColumnName="id", unique=false, nullable=true, insertable=true, updatable=true)
    public SalesProject getSales() {
        return this.sales;
    }

    public void setSales(SalesProject aSales) {
        this.sales = aSales;
    }

    @Embedded
    public MonthlyHeader getHeader() {
        return this.header;
    }

    public void setHeader(MonthlyHeader aMonthlyHeader) {
        this.header = aMonthlyHeader;
    }

    @Transient
    public MonthlyHeader prepareTimes() {
        GregorianCalendar cal = new GregorianCalendar();
        Date ym = this.getActivity().getStartYmd();
        cal.setTime(ym);
        MonthlyHeader mh = new MonthlyHeader();
        mh.setYm01(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm02(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm03(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm04(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm05(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm06(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm07(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm08(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm09(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm10(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm11(cal.getTime());
        ((Calendar)cal).add(2, 1);
        mh.setYm12(cal.getTime());
        if (this.getHeader() == null) {
            this.setHeader(mh);
        }
        return mh;
    }

    @Transient
    public List<MonthlyProfitLoss> getPls() {
        return this.pls;
    }

    public void setPls(List<MonthlyProfitLoss> aPls) {
        this.pls = aPls;
    }

    @Transient
    public void prepareDiffCash() {
        ArrayList<MonthlyProfitLoss> tmps = new ArrayList<MonthlyProfitLoss>();
        MonthlyProfitLoss pm = new MonthlyProfitLoss();
        pm.setCat("\u4e88\u5b9a\u984d");
        tmps.add(pm);
        MonthlyProfitLoss dm = new MonthlyProfitLoss();
        dm.setCat("\u5b9f\u7e3e\u984d");
        tmps.add(dm);
        this.setPls(tmps);
    }

    @Transient
    public void prepareDiffWork() {
        ArrayList<MonthlyProfitLoss> tmps = new ArrayList<MonthlyProfitLoss>();
        MonthlyProfitLoss pt = new MonthlyProfitLoss();
        pt.setCat("\u4e88\u5b9a\u5de5\u6570");
        tmps.add(pt);
        MonthlyProfitLoss dt = new MonthlyProfitLoss();
        dt.setCat("\u5b9f\u7e3e\u5de5\u6570");
        tmps.add(dt);
        this.setPls(tmps);
    }

    @Transient
    public void prepareDiffPl() {
        ArrayList<MonthlyProfitLoss> tmps = new ArrayList<MonthlyProfitLoss>();
        MonthlyProfitLoss ud = new MonthlyProfitLoss();
        ud.setCat("\u58f2\u4e0a\u9ad8");
        tmps.add(ud);
        MonthlyProfitLoss bt = new MonthlyProfitLoss();
        bt.setCat("\u539f\u4fa1\uff08\u4eba\u4ef6\u8cbb\uff09");
        tmps.add(bt);
        MonthlyProfitLoss be = new MonthlyProfitLoss();
        be.setCat("\u539f\u4fa1\uff08\u7d4c\u8cbb\uff09");
        tmps.add(be);
        MonthlyProfitLoss bp = new MonthlyProfitLoss();
        bp.setCat("\u539f\u4fa1\uff08\u5916\u6ce8\u8cbb\uff09");
        tmps.add(bp);
        MonthlyProfitLoss op = new MonthlyProfitLoss();
        op.setCat("\u8ca9\u7ba1\u8cbb\uff08\u4eba\u4ef6\u8cbb\uff09");
        tmps.add(op);
        MonthlyProfitLoss oe = new MonthlyProfitLoss();
        oe.setCat("\u8ca9\u7ba1\u8cbb\uff08\u7d4c\u8cbb\uff09");
        tmps.add(oe);
        MonthlyProfitLoss ar = new MonthlyProfitLoss();
        ar.setCat("\u7c97\u5229\u76ca");
        tmps.add(ar);
        MonthlyProfitLoss kr = new MonthlyProfitLoss();
        kr.setCat("\u8ca2\u732e\u5229\u76ca");
        tmps.add(kr);
        this.setPls(tmps);
    }

    @Transient
    public void prepareCashflow() {
        MonthlyCashflow bill = this.getCashflow().getWorkBill();
        MonthlyCashflow in = this.getCashflow().getWorkIn();
        MonthlyCashflow out = this.getCashflow().getWorkOut();
        ArrayList<MonthlyProfitLoss> tmps = new ArrayList<MonthlyProfitLoss>();
        MonthlyProfitLoss bm = new MonthlyProfitLoss();
        bm.setCat("\u8acb\u6c42\u984d");
        bm.setPl01(bill.getM01());
        bm.setPl02(bill.getM02());
        bm.setPl03(bill.getM03());
        bm.setPl04(bill.getM04());
        bm.setPl05(bill.getM05());
        bm.setPl06(bill.getM06());
        bm.setPl07(bill.getM07());
        bm.setPl08(bill.getM08());
        bm.setPl09(bill.getM09());
        bm.setPl10(bill.getM10());
        bm.setPl11(bill.getM11());
        bm.setPl12(bill.getM12());
        tmps.add(bm);
        MonthlyProfitLoss im = new MonthlyProfitLoss();
        im.setCat("\u5165\u91d1\u984d");
        im.setPl01(in.getM01());
        im.setPl02(in.getM02());
        im.setPl03(in.getM03());
        im.setPl04(in.getM04());
        im.setPl05(in.getM05());
        im.setPl06(in.getM06());
        im.setPl07(in.getM07());
        im.setPl08(in.getM08());
        im.setPl09(in.getM09());
        im.setPl10(in.getM10());
        im.setPl11(in.getM11());
        im.setPl12(in.getM12());
        tmps.add(im);
        MonthlyProfitLoss om = new MonthlyProfitLoss();
        om.setCat("\u51fa\u91d1\u984d");
        om.setPl01(out.getM01());
        om.setPl02(out.getM02());
        om.setPl03(out.getM03());
        om.setPl04(out.getM04());
        om.setPl05(out.getM05());
        om.setPl06(out.getM06());
        om.setPl07(out.getM07());
        om.setPl08(out.getM08());
        om.setPl09(out.getM09());
        om.setPl10(out.getM10());
        om.setPl11(out.getM11());
        om.setPl12(out.getM12());
        tmps.add(om);
        this.setPls(tmps);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

