/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.common.MonthlyCashflow;
import jp.sourceforge.kuzumeji.entity.event.Plan;
import jp.sourceforge.kuzumeji.entity.event.PlanCashflowMonthly;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="plan_cashflow", schema="e", uniqueConstraints={@UniqueConstraint(columnNames={"plan_id"})})
@EntityListeners(value={EntityListenerCallback.class})
public class PlanCashflow
implements Serializable,
Cloneable,
HistoryManager {
    private static final long serialVersionUID = 4049168056193607989L;
    private Long id;
    private Plan plan;
    private Integer ddBill;
    private Integer ddIn;
    private Integer ddOut;
    private Long verno;
    private History history;
    private List<PlanCashflowMonthly> cashflows = new ArrayList<PlanCashflowMonthly>(0);
    private MonthlyCashflow workBill;
    private MonthlyCashflow workIn;
    private MonthlyCashflow workOut;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @OneToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="plan_id", referencedColumnName="id", unique=false, nullable=false, insertable=true, updatable=true)
    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan aPlan) {
        this.plan = aPlan;
    }

    @Column(name="dd_bill", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getDdBill() {
        return this.ddBill;
    }

    public void setDdBill(Integer aDdBill) {
        this.ddBill = aDdBill;
    }

    @Column(name="dd_in", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getDdIn() {
        return this.ddIn;
    }

    public void setDdIn(Integer aDdIn) {
        this.ddIn = aDdIn;
    }

    @Column(name="dd_out", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getDdOut() {
        return this.ddOut;
    }

    public void setDdOut(Integer aDdOut) {
        this.ddOut = aDdOut;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Override
    @Embedded
    public History getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="planCashflow")
    public List<PlanCashflowMonthly> getCashflows() {
        return this.cashflows;
    }

    public void setCashflows(List<PlanCashflowMonthly> aPlanCashflowMonthlies) {
        this.cashflows = aPlanCashflowMonthlies;
    }

    @Embedded
    public MonthlyCashflow getWorkBill() {
        return this.workBill;
    }

    public void setWorkBill(MonthlyCashflow aMonthlyCashflowBill) {
        this.workBill = aMonthlyCashflowBill;
    }

    @Embedded
    public MonthlyCashflow getWorkIn() {
        return this.workIn;
    }

    public void setWorkIn(MonthlyCashflow aMonthlyCashflowIn) {
        this.workIn = aMonthlyCashflowIn;
    }

    @Embedded
    public MonthlyCashflow getWorkOut() {
        return this.workOut;
    }

    public void setWorkOut(MonthlyCashflow aMonthlyCashflowOut) {
        this.workOut = aMonthlyCashflowOut;
    }

    @Transient
    public Long getCashBillByYm(Integer aY, Integer aM) {
        PlanCashflowMonthly pcm = this.getPlanCashflowMonthlyByYm(aY, aM);
        return pcm != null ? pcm.getCashBill() : 0L;
    }

    @Transient
    public Long getCashInByYm(Integer aY, Integer aM) {
        PlanCashflowMonthly pcm = this.getPlanCashflowMonthlyByYm(aY, aM);
        return pcm != null ? pcm.getCashIn() : 0L;
    }

    @Transient
    public Long getCashOutByYm(Integer aY, Integer aM) {
        PlanCashflowMonthly pcm = this.getPlanCashflowMonthlyByYm(aY, aM);
        return pcm != null ? pcm.getCashOut() : 0L;
    }

    private PlanCashflowMonthly getPlanCashflowMonthlyByYm(Integer aY, Integer aM) {
        GregorianCalendar cal = new GregorianCalendar();
        for (PlanCashflowMonthly pcm : this.cashflows) {
            cal.setTime(pcm.getYm());
            if (aY.intValue() != cal.get(1) || aM.intValue() != cal.get(2)) continue;
            return pcm;
        }
        return null;
    }

    @Transient
    public void prepareCashflow() {
        GregorianCalendar cal = new GregorianCalendar();
        PlanCashflow planCashflow = this;
        Date ym = planCashflow.getPlan().getActivity().getStartYmd();
        cal.setTime(ym);
        MonthlyCashflow mcBill = new MonthlyCashflow();
        MonthlyCashflow mcIn = new MonthlyCashflow();
        MonthlyCashflow mcOut = new MonthlyCashflow();
        PlanCashflowMonthly pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM01(pcm.getCashBill());
            mcIn.setM01(pcm.getCashIn());
            mcOut.setM01(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM02(pcm.getCashBill());
            mcIn.setM02(pcm.getCashIn());
            mcOut.setM02(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM03(pcm.getCashBill());
            mcIn.setM03(pcm.getCashIn());
            mcOut.setM03(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM04(pcm.getCashBill());
            mcIn.setM04(pcm.getCashIn());
            mcOut.setM04(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM05(pcm.getCashBill());
            mcIn.setM05(pcm.getCashIn());
            mcOut.setM05(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM06(pcm.getCashBill());
            mcIn.setM06(pcm.getCashIn());
            mcOut.setM06(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM07(pcm.getCashBill());
            mcIn.setM07(pcm.getCashIn());
            mcOut.setM07(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM08(pcm.getCashBill());
            mcIn.setM08(pcm.getCashIn());
            mcOut.setM08(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM09(pcm.getCashBill());
            mcIn.setM09(pcm.getCashIn());
            mcOut.setM09(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM10(pcm.getCashBill());
            mcIn.setM10(pcm.getCashIn());
            mcOut.setM10(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM11(pcm.getCashBill());
            mcIn.setM11(pcm.getCashIn());
            mcOut.setM11(pcm.getCashOut());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getPlanCashflowMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcBill.setM12(pcm.getCashBill());
            mcIn.setM12(pcm.getCashIn());
            mcOut.setM12(pcm.getCashOut());
        }
        if (planCashflow.getWorkBill() == null) {
            planCashflow.setWorkBill(mcBill);
        }
        if (planCashflow.getWorkIn() == null) {
            planCashflow.setWorkIn(mcIn);
        }
        if (planCashflow.getWorkOut() == null) {
            planCashflow.setWorkOut(mcOut);
        }
    }

    @Transient
    public Long getM01() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM01() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM01() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM02() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM02() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM02() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM03() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM03() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM03() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM04() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM04() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM04() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM05() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM05() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM05() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM06() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM06() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM06() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM07() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM07() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM07() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM08() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM08() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM08() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM09() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM09() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM09() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM10() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM10() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM10() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM11() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM11() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM11() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getM12() {
        Long i = this.getWorkIn() != null ? this.getWorkIn().getM12() : 0L;
        Long o = this.getWorkOut() != null ? this.getWorkOut().getM12() : 0L;
        return this.calcCashflow(i, o);
    }

    @Transient
    public Long getTotal() {
        long cash = this.getM01() + this.getM02() + this.getM03() + this.getM04() + this.getM05() + this.getM06();
        return cash += this.getM07() + this.getM08() + this.getM09() + this.getM10() + this.getM11() + this.getM12();
    }

    private long calcCashflow(Long aIn, Long aOut) {
        long in = aIn != null ? aIn : 0L;
        long out = aOut != null ? aOut : 0L;
        return in - out;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

