/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.common.MonthlyExpense;
import jp.sourceforge.kuzumeji.entity.event.Plan;
import jp.sourceforge.kuzumeji.entity.event.PlanExpenseMonthly;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="plan_expense", schema="e", uniqueConstraints={})
@EntityListeners(value={EntityListenerCallback.class})
public class PlanExpense
implements Serializable,
Cloneable,
HistoryManager {
    private static final long serialVersionUID = -7564058930525387006L;
    private Long id;
    private Plan plan;
    private String cat;
    private String item;
    private Long price;
    private Long num;
    private Long verno;
    private History history;
    private List<PlanExpenseMonthly> expenses = new ArrayList<PlanExpenseMonthly>(0);
    private MonthlyExpense work;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="plan_id", referencedColumnName="id", unique=false, nullable=false, insertable=true, updatable=true)
    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan aPlan) {
        this.plan = aPlan;
    }

    @Column(name="cat", unique=false, nullable=false, insertable=true, updatable=true)
    public String getCat() {
        return this.cat;
    }

    public void setCat(String aCostType) {
        this.cat = aCostType;
    }

    @Column(name="item", unique=false, nullable=false, insertable=true, updatable=true)
    public String getItem() {
        return this.item;
    }

    public void setItem(String aItem) {
        this.item = aItem;
    }

    @Column(name="price", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getPrice() {
        return this.price;
    }

    public void setPrice(Long aPrice) {
        this.price = aPrice;
    }

    @Column(name="num", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getNum() {
        return this.num;
    }

    public void setNum(Long aNum) {
        this.num = aNum;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Override
    @Embedded
    public History getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="planExpense")
    public List<PlanExpenseMonthly> getExpenses() {
        return this.expenses;
    }

    public void setExpenses(List<PlanExpenseMonthly> aPlanExpenseMonthlies) {
        this.expenses = aPlanExpenseMonthlies;
    }

    @Embedded
    public MonthlyExpense getWork() {
        return this.work;
    }

    public void setWork(MonthlyExpense aMonthlyExpense) {
        this.work = aMonthlyExpense;
    }

    public Long getExpenseByYm(int aY, int aM) {
        GregorianCalendar cal = new GregorianCalendar();
        for (PlanExpenseMonthly time : this.expenses) {
            cal.setTime(time.getYm());
            int tmpY = cal.get(1);
            int tmpM = cal.get(2);
            if (aY != tmpY || aM != tmpM) continue;
            return time.getCost();
        }
        return 0L;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Transient
    public void prepareExpenses() {
        GregorianCalendar cal = new GregorianCalendar();
        PlanExpense planExpense = this;
        Date ym = planExpense.getPlan().getActivity().getStartYmd();
        cal.setTime(ym);
        MonthlyExpense me = new MonthlyExpense();
        me.setE01(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE02(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE03(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE04(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE05(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE06(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE07(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE08(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE09(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE10(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE11(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        me.setE12(planExpense.getExpenseByYm(cal.get(1), cal.get(2)));
        if (planExpense.getWork() == null) {
            planExpense.setWork(me);
        }
    }
}

