/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.common.MonthlyTime;
import jp.sourceforge.kuzumeji.entity.event.Plan;
import jp.sourceforge.kuzumeji.entity.event.PlanPersonMonthly;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="plan_person", schema="e", uniqueConstraints={@UniqueConstraint(columnNames={"plan_id", "role", "person_no"})})
@EntityListeners(value={EntityListenerCallback.class})
public class PlanPerson
implements Serializable,
Cloneable,
HistoryManager {
    private static final long serialVersionUID = 3000019109591326709L;
    private Long id;
    private Plan plan;
    private String role = "\u30e1\u30f3\u30d0";
    private Person person;
    private Long costPrice = 0L;
    private Long unitPrice = 0L;
    private Long verno;
    private History history;
    private List<PlanPersonMonthly> times = new ArrayList<PlanPersonMonthly>(0);
    private MonthlyTime work;
    private Long defaultCostPrice = 0L;
    private Long defaultUnitPrice = 0L;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="plan_id", referencedColumnName="id", unique=false, nullable=false, insertable=true, updatable=true)
    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan aPlan) {
        this.plan = aPlan;
    }

    @Column(name="role", unique=false, nullable=false, insertable=true, updatable=true)
    public String getRole() {
        return this.role;
    }

    public void setRole(String aRole) {
        this.role = aRole;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="person_no", referencedColumnName="no", unique=false, nullable=false, insertable=true, updatable=true)
    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person aPerson) {
        this.person = aPerson;
    }

    @Column(name="cost_price", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getCostPrice() {
        return this.costPrice;
    }

    public void setCostPrice(Long aBasicCost) {
        this.costPrice = aBasicCost;
    }

    @Column(name="unit_price", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Long aSalesCost) {
        this.unitPrice = aSalesCost;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Override
    @Embedded
    public History getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="planPerson")
    public List<PlanPersonMonthly> getTimes() {
        return this.times;
    }

    public void setTimes(List<PlanPersonMonthly> aPlanPersonMonthlies) {
        this.times = aPlanPersonMonthlies;
    }

    @Embedded
    public MonthlyTime getWork() {
        return this.work;
    }

    public void setWork(MonthlyTime aMonthlyTime) {
        this.work = aMonthlyTime;
    }

    @Transient
    public Long getDefaultCostPrice() {
        return this.defaultCostPrice;
    }

    public void setDefaultCostPrice(Long aDefaultCostPrice) {
        this.defaultCostPrice = aDefaultCostPrice;
    }

    @Transient
    public Long getDefaultUnitPrice() {
        return this.defaultUnitPrice;
    }

    public void setDefaultUnitPrice(Long aDefaultUnitPrice) {
        this.defaultUnitPrice = aDefaultUnitPrice;
    }

    @Transient
    public void prepareTimes() {
        GregorianCalendar cal = new GregorianCalendar();
        PlanPerson planPerson = this;
        Date ym = planPerson.getPlan().getActivity().getStartYmd();
        cal.setTime(ym);
        MonthlyTime mt = new MonthlyTime();
        mt.setT01(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT02(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT03(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT04(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT05(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT06(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        mt.setT07(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT08(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT09(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT10(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT11(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        cal.set(2, cal.get(2) + 1);
        mt.setT12(planPerson.getTimeByYm(cal.get(1), cal.get(2)));
        if (planPerson.getWork() == null) {
            planPerson.setWork(mt);
        }
    }

    @Transient
    public double getTimeByYm(int aY, int aM) {
        GregorianCalendar cal = new GregorianCalendar();
        for (PlanPersonMonthly time : this.times) {
            cal.setTime(time.getYm());
            int tmpY = cal.get(1);
            int tmpM = cal.get(2);
            if (aY != tmpY || aM != tmpM) continue;
            return time.getTime();
        }
        return 0.0;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

