/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.common.MonthlyCashflow;
import jp.sourceforge.kuzumeji.entity.common.MonthlyYmd;
import jp.sourceforge.kuzumeji.entity.event.Plan;
import jp.sourceforge.kuzumeji.entity.event.SalesProjectMonthly;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="sales_project", schema="e", uniqueConstraints={@UniqueConstraint(columnNames={"plan_id"})})
@EntityListeners(value={EntityListenerCallback.class})
public class SalesProject
implements Serializable,
Cloneable,
HistoryManager {
    private static final long serialVersionUID = -5211076584927308671L;
    private Long id;
    private Plan plan;
    private Long verno;
    private History history;
    private List<SalesProjectMonthly> saleses = new ArrayList<SalesProjectMonthly>(0);
    private MonthlyCashflow workSales;
    private MonthlyYmd workInYmd;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @OneToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="plan_id", referencedColumnName="id", unique=false, nullable=false, insertable=true, updatable=true)
    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan aPlan) {
        this.plan = aPlan;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Override
    @Embedded
    public History getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="salesProject")
    public List<SalesProjectMonthly> getSaleses() {
        return this.saleses;
    }

    public void setSaleses(List<SalesProjectMonthly> aPlanCashflowMonthlies) {
        this.saleses = aPlanCashflowMonthlies;
    }

    @Embedded
    public MonthlyCashflow getWorkSales() {
        return this.workSales;
    }

    public void setWorkSales(MonthlyCashflow aWorkSales) {
        this.workSales = aWorkSales;
    }

    @Embedded
    public MonthlyYmd getWorkInYmd() {
        return this.workInYmd;
    }

    public void setWorkInYmd(MonthlyYmd aWorkInYmd) {
        this.workInYmd = aWorkInYmd;
    }

    @Transient
    public Long getSalesByYm(Integer aY, Integer aM) {
        SalesProjectMonthly spm = this.getSalesProjectMonthlyByYm(aY, aM);
        return spm != null ? spm.getCashSales() : 0L;
    }

    private SalesProjectMonthly getSalesProjectMonthlyByYm(Integer aY, Integer aM) {
        GregorianCalendar cal = new GregorianCalendar();
        for (SalesProjectMonthly pcm : this.saleses) {
            cal.setTime(pcm.getYm());
            if (aY.intValue() != cal.get(1) || aM.intValue() != cal.get(2)) continue;
            return pcm;
        }
        return null;
    }

    @Transient
    public void prepareSales() {
        GregorianCalendar cal = new GregorianCalendar();
        SalesProject salesProject = this;
        Date ym = salesProject.getPlan().getActivity().getStartYmd();
        cal.setTime(ym);
        MonthlyCashflow mcSales = new MonthlyCashflow();
        MonthlyYmd mcYmd = new MonthlyYmd();
        SalesProjectMonthly pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM01(pcm.getCashSales());
            mcYmd.setD01(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM02(pcm.getCashSales());
            mcYmd.setD02(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM03(pcm.getCashSales());
            mcYmd.setD03(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM04(pcm.getCashSales());
            mcYmd.setD04(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM05(pcm.getCashSales());
            mcYmd.setD05(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM06(pcm.getCashSales());
            mcYmd.setD06(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM07(pcm.getCashSales());
            mcYmd.setD07(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM08(pcm.getCashSales());
            mcYmd.setD08(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM09(pcm.getCashSales());
            mcYmd.setD09(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM10(pcm.getCashSales());
            mcYmd.setD10(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM11(pcm.getCashSales());
            mcYmd.setD11(pcm.getYmdIn());
        }
        cal.set(2, cal.get(2) + 1);
        pcm = this.getSalesProjectMonthlyByYm(cal.get(1), cal.get(2));
        if (pcm != null) {
            mcSales.setM12(pcm.getCashSales());
            mcYmd.setD12(pcm.getYmdIn());
        }
        if (salesProject.getWorkSales() == null) {
            salesProject.setWorkSales(mcSales);
        }
        if (salesProject.getWorkInYmd() == null) {
            salesProject.setWorkInYmd(mcYmd);
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

