/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.BillManager;
import jp.sourceforge.kuzumeji.entity.ContactManager;
import jp.sourceforge.kuzumeji.entity.CreditManager;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.Bill;
import jp.sourceforge.kuzumeji.entity.common.Contact;
import jp.sourceforge.kuzumeji.entity.common.Credit;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.resource.CompanySales;
import jp.sourceforge.kuzumeji.entity.resource.Group;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="company", schema="r", uniqueConstraints={@UniqueConstraint(columnNames={"no"})})
@EntityListeners(value={EntityListenerCallback.class})
public class Company
implements Serializable,
Cloneable,
HistoryManager,
ContactManager,
BillManager,
CreditManager {
    private static final long serialVersionUID = 8081766907152662337L;
    private Long id;
    private String cat;
    private String no;
    private boolean creditDebt = false;
    private String alias;
    private String name;
    private String kana;
    private Group group;
    private String product;
    private String note;
    private Person salesman;
    private Person leader;
    private Contact contact;
    private Bill bill;
    private Person manager;
    private Credit credit;
    private Long verno;
    private History history;
    private List<CompanySales> saleses = new ArrayList<CompanySales>(0);

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @Column(name="cat", unique=false, nullable=true, insertable=true, updatable=true)
    public String getCat() {
        return this.cat;
    }

    public void setCat(String aCat) {
        this.cat = aCat;
    }

    @Column(name="no", unique=true, nullable=false, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    public String getNo() {
        return this.no;
    }

    public void setNo(String aNo) {
        this.no = aNo;
    }

    @Column(name="credit_debt", unique=false, nullable=true, insertable=true, updatable=true)
    public boolean isCreditDebt() {
        return this.creditDebt;
    }

    public void setCreditDebt(boolean aCreditDebt) {
        this.creditDebt = aCreditDebt;
    }

    @Column(name="alias", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String aAlias) {
        this.alias = aAlias;
    }

    @Column(name="name", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Column(name="kana", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getKana() {
        return this.kana;
    }

    public void setKana(String aKana) {
        this.kana = aKana;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="group_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group aGroup) {
        this.group = aGroup;
    }

    @Column(name="product", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String aProduct) {
        this.product = aProduct;
    }

    @Column(name="note", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=1000, message="\u6700\u59271000\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getNote() {
        return this.note;
    }

    public void setNote(String aNote) {
        this.note = aNote;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="salesman_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Person getSalesman() {
        return this.salesman;
    }

    public void setSalesman(Person aSalesman) {
        this.salesman = aSalesman;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="leader_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Person getLeader() {
        return this.leader;
    }

    public void setLeader(Person aLeader) {
        this.leader = aLeader;
    }

    @Override
    @Embedded
    public Contact getContact() {
        return this.contact;
    }

    @Override
    public void setContact(Contact aContact) {
        this.contact = aContact;
    }

    @Override
    @Embedded
    public Bill getBill() {
        return this.bill;
    }

    @Override
    public void setBill(Bill aBill) {
        this.bill = aBill;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="manager_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Person getManager() {
        return this.manager;
    }

    public void setManager(Person aManager) {
        this.manager = aManager;
    }

    @Override
    @Embedded
    public Credit getCredit() {
        return this.credit;
    }

    @Override
    public void setCredit(Credit aCredit) {
        this.credit = aCredit;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Override
    @Embedded
    public History getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="company")
    public List<CompanySales> getSaleses() {
        return this.saleses;
    }

    public void setSaleses(List<CompanySales> aSaleses) {
        this.saleses = aSaleses;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

