/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.resource;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.ContactManager;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.RoleManager;
import jp.sourceforge.kuzumeji.entity.common.Contact;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.common.Role;
import jp.sourceforge.kuzumeji.entity.resource.Company;
import jp.sourceforge.kuzumeji.entity.resource.Unit;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

@Entity
@Table(name="person", schema="r", uniqueConstraints={@UniqueConstraint(columnNames={"no"})})
@EntityListeners(value={EntityListenerCallback.class})
public class Person
implements Serializable,
Cloneable,
HistoryManager,
ContactManager,
RoleManager {
    private static final long serialVersionUID = 2341471068763837096L;
    private Long id;
    private String cat;
    private String pid;
    private String no;
    private boolean active = true;
    private String password;
    private String name;
    private String kana;
    private String jobRank;
    private Double restPaidVacationHour = 0.0;
    private Double restAltVacationHour = 0.0;
    private Unit unit;
    private String team;
    private Role role;
    private Company company;
    private Long monthlyCost = 0L;
    private Long hourlyCost = 0L;
    private Long dailyCost = 0L;
    private Double workRate = 100.0;
    private Long goalSales = 0L;
    private String originalNo;
    private String originalName;
    private Contact contact;
    private Long verno;
    private History history;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @Column(name="cat", unique=false, nullable=false, insertable=true, updatable=true)
    public String getCat() {
        return this.cat;
    }

    public void setCat(String aCat) {
        this.cat = aCat;
    }

    @Column(name="pid", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    public String getPid() {
        return this.pid;
    }

    public void setPid(String aPid) {
        this.pid = aPid;
    }

    @Column(name="no", unique=true, nullable=false, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    public String getNo() {
        return this.no;
    }

    public void setNo(String aNo) {
        this.no = aNo;
    }

    @Column(name="active", unique=false, nullable=false, insertable=true, updatable=true)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean aActive) {
        this.active = aActive;
    }

    @Column(name="password", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
    }

    @Column(name="name", unique=false, nullable=false, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Column(name="kana", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getKana() {
        return this.kana;
    }

    public void setKana(String aKana) {
        this.kana = aKana;
    }

    @Column(name="job_rank", unique=false, nullable=true, insertable=true, updatable=true)
    public String getJobRank() {
        return this.jobRank;
    }

    public void setJobRank(String aJobRank) {
        this.jobRank = aJobRank;
    }

    @Column(name="rest_paid_vacation_hour", unique=false, nullable=false, insertable=true, updatable=true, precision=8, scale=0)
    public Double getRestPaidVacationHour() {
        return this.restPaidVacationHour;
    }

    public void setRestPaidVacationHour(Double aRestPaidVacationHour) {
        this.restPaidVacationHour = aRestPaidVacationHour;
    }

    @Column(name="rest_alt_vacation_hour", unique=false, nullable=false, insertable=true, updatable=true, precision=8, scale=0)
    public Double getRestAltVacationHour() {
        return this.restAltVacationHour;
    }

    public void setRestAltVacationHour(Double aRestAltVacationHour) {
        this.restAltVacationHour = aRestAltVacationHour;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="unit_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit aMUnit) {
        this.unit = aMUnit;
    }

    @Column(name="team", unique=false, nullable=true, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getTeam() {
        return this.team;
    }

    public void setTeam(String aTeam) {
        this.team = aTeam;
    }

    @Embedded
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role aAppRole) {
        this.role = aAppRole;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="company_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company aCompany) {
        this.company = aCompany;
    }

    @Column(name="monthly_cost", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getMonthlyCost() {
        return this.monthlyCost;
    }

    public void setMonthlyCost(Long aMonthlyCost) {
        this.monthlyCost = aMonthlyCost;
    }

    @Column(name="hourly_cost", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getHourlyCost() {
        return this.hourlyCost;
    }

    public void setHourlyCost(Long aHourlyCost) {
        this.hourlyCost = aHourlyCost;
    }

    @Column(name="daily_cost", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getDailyCost() {
        return this.dailyCost;
    }

    public void setDailyCost(Long aDailyCost) {
        this.dailyCost = aDailyCost;
    }

    @Column(name="work_rate", unique=false, nullable=false, insertable=true, updatable=true, precision=8, scale=0)
    public Double getWorkRate() {
        return this.workRate;
    }

    public void setWorkRate(Double aWorkRate) {
        this.workRate = aWorkRate;
    }

    @Column(name="goal_sales", unique=false, nullable=false, insertable=true, updatable=true, precision=8, scale=0)
    public Long getGoalSales() {
        return this.goalSales;
    }

    public void setGoalSales(Long aGoalSales) {
        this.goalSales = aGoalSales;
    }

    @Transient
    public String getOriginalNo() {
        return this.originalNo;
    }

    public void setOriginalNo(String aOriginalNo) {
        this.originalNo = aOriginalNo;
    }

    @Transient
    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String aOriginalName) {
        this.originalName = aOriginalName;
    }

    @Embedded
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact aContact) {
        this.contact = aContact;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Embedded
    public History getHistory() {
        return this.history;
    }

    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

