/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.entity.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import jp.sourceforge.kuzumeji.entity.EntityListenerCallback;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.event.Activity;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import jp.sourceforge.kuzumeji.entity.resource.UnitSales;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="unit", schema="r", uniqueConstraints={@UniqueConstraint(columnNames={"no"})})
@EntityListeners(value={EntityListenerCallback.class})
public class Unit
implements Serializable,
Cloneable,
HistoryManager {
    private static final long serialVersionUID = 6121492944710646484L;
    private Long id;
    private String no;
    private String name;
    private Person manager;
    private Long verno;
    private History history;
    private List<UnitSales> saleses = new ArrayList<UnitSales>(0);
    private UnitSales unitSales;
    private List<Activity> activitys = new ArrayList<Activity>(0);
    private List<Activity> yearActivitys = new ArrayList<Activity>(0);

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long aId) {
        this.id = aId;
    }

    @Column(name="no", unique=true, nullable=false, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    public String getNo() {
        return this.no;
    }

    public void setNo(String aUnitNo) {
        this.no = aUnitNo;
    }

    @Column(name="name", unique=false, nullable=false, insertable=true, updatable=true)
    @Length(max=100, message="\u6700\u5927100\u6587\u5b57\u9577\u3067\u3059\u3002")
    @Pattern(regex="[^ -~\uff61-\uff9f]*", message="\u5168\u89d2\u6587\u5b57\u306e\u307f\u3067\u3059\u3002")
    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="manager_no", referencedColumnName="no", unique=false, nullable=true, insertable=true, updatable=true)
    public Person getManager() {
        return this.manager;
    }

    public void setManager(Person aManager) {
        this.manager = aManager;
    }

    @Version
    @Column(name="verno", unique=false, nullable=false, insertable=true, updatable=true)
    public Long getVerno() {
        return this.verno;
    }

    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }

    @Override
    @Embedded
    public History getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(History aHistory) {
        this.history = aHistory;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="unit")
    public List<UnitSales> getSaleses() {
        return this.saleses;
    }

    public void setSaleses(List<UnitSales> aMSaleses) {
        this.saleses = aMSaleses;
    }

    @Transient
    public UnitSales getSales() {
        return this.unitSales;
    }

    public void setSales(UnitSales aUnitSales) {
        this.unitSales = aUnitSales;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="unit")
    public List<Activity> getActivitys() {
        return this.activitys;
    }

    public void setActivitys(List<Activity> aActivitys) {
        this.activitys = aActivitys;
    }

    @Transient
    public List<Activity> getYearActivitys() {
        return this.yearActivitys;
    }

    public void setYearActivitys(List<Activity> aYearActivitys) {
        this.yearActivitys = aYearActivitys;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

