/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.session.action;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import jp.sourceforge.kuzumeji.session.action.Authenticator;
import jp.sourceforge.kuzumeji.session.action.LdapUtil;
import jp.sourceforge.kuzumeji.session.conversation.query.resource.ParamList;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;

@Stateless
@Name(value="authenticator")
public class AuthenticatorBean
implements Authenticator {
    @Logger
    Log log;
    @PersistenceContext
    EntityManager em;
    @In(value="paramList", create=true, required=true)
    private ParamList paramList;
    @In
    Identity identity;
    @In(required=false, create=true)
    private String switchNo;
    @Out(value="mine", required=false, scope=ScopeType.SESSION)
    private Person mine;

    public boolean authenticate() {
        String ldapUrl = this.paramList.getConstantVal("LDAP\u63a5\u7d9a\u5148");
        boolean useLdap = ldapUrl != null && ldapUrl.length() > 0;
        String username = this.identity.getUsername();
        String password = this.identity.getPassword();
        if (useLdap) {
            String ldapDomain = this.paramList.getConstantVal("LDAP\u30c9\u30e1\u30a4\u30f3");
            boolean useLdapDomain = ldapDomain != null && ldapDomain.length() > 0;
            String ldapUserName = useLdapDomain ? username + "@" + ldapDomain : username;
            boolean flag = LdapUtil.auth(ldapUrl, ldapUserName, password);
            if (!flag) {
                this.log.warn((Object)"LDAP Login failed. [eno:#0]", new Object[]{username});
                return false;
            }
            try {
                this.mine = (Person)this.em.createQuery("select a from Person a where a.pid=#{identity.username}").getSingleResult();
            }
            catch (NoResultException e) {
                this.log.warn((Object)"DB User NOT Found. [eno:#0]", new Object[]{username});
                return false;
            }
        }
        try {
            this.mine = (Person)this.em.createQuery("select a from Person a where a.no=#{identity.username} and a.password=#{identity.password}").getSingleResult();
        }
        catch (NoResultException e) {
            this.log.warn((Object)"DB Login failed. [eno:#0]", new Object[]{username});
            return false;
        }
        if (!this.mine.isActive()) {
            this.log.warn((Object)"Login failed. [eno:#0] is NOT Active.", new Object[]{username});
            return false;
        }
        this.log.info((Object)"Login successed. [no=#0,role[resource:#1,activity:#2,plan:#3,do:#4,check=#5,su=#6,sales=#7,customer=#8,accounting=#9]]", new Object[]{this.mine.getNo(), this.mine.getRole().isResource(), this.mine.getRole().isActivity(), this.mine.getRole().isPlan(), this.mine.getRole().isDoit(), this.mine.getRole().isCheck(), this.mine.getRole().isSu(), this.mine.getRole().isSales(), this.mine.getRole().isCustomer(), this.mine.getRole().isAccounting()});
        if (this.switchNo.length() > 0) {
            if (!this.mine.getRole().isSu()) {
                this.log.error((Object)"Switch failed. NOT Allowed.", new Object[0]);
                return false;
            }
            try {
                this.log.debug((Object)"switchNo:#0", new Object[]{this.switchNo});
                String originalNo = this.mine.getNo();
                String originalName = this.mine.getName();
                this.mine = (Person)this.em.createQuery("select a from Person a where a.no=:pno").setParameter("pno", (Object)this.switchNo).getSingleResult();
                this.mine.setOriginalNo(originalNo);
                this.mine.setOriginalName(originalName);
            }
            catch (NoResultException e) {
                this.log.warn((Object)"Switch failed. [eno:#0]", new Object[]{this.switchNo});
                return false;
            }
            if (!this.mine.isActive()) {
                this.log.warn((Object)"Switch failed. [eno:#0] is NOT Active.", new Object[]{this.switchNo});
                return false;
            }
        }
        if (this.mine.getRole().isResource()) {
            this.identity.addRole("resource");
        }
        if (this.mine.getRole().isActivity()) {
            this.identity.addRole("activity");
        }
        if (this.mine.getRole().isPlan()) {
            this.identity.addRole("plan");
        }
        if (this.mine.getRole().isDoit()) {
            this.identity.addRole("do");
        }
        if (this.mine.getRole().isCheck()) {
            this.identity.addRole("check");
        }
        if (this.mine.getRole().isSu()) {
            this.identity.addRole("su");
        }
        if (this.mine.getRole().isSales()) {
            this.identity.addRole("sales");
        }
        if (this.mine.getRole().isCustomer()) {
            this.identity.addRole("customer");
        }
        if (this.mine.getRole().isAccounting()) {
            this.identity.addRole("accounting");
        }
        return true;
    }
}

