/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.session.conversation.home;

import javax.faces.application.FacesMessage;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import jp.sourceforge.kuzumeji.entity.BillManager;
import jp.sourceforge.kuzumeji.entity.BizManager;
import jp.sourceforge.kuzumeji.entity.ContactManager;
import jp.sourceforge.kuzumeji.entity.ContractManager;
import jp.sourceforge.kuzumeji.entity.CreditManager;
import jp.sourceforge.kuzumeji.entity.HistoryManager;
import jp.sourceforge.kuzumeji.entity.PriceManager;
import jp.sourceforge.kuzumeji.entity.RoleManager;
import jp.sourceforge.kuzumeji.entity.common.Bill;
import jp.sourceforge.kuzumeji.entity.common.Biz;
import jp.sourceforge.kuzumeji.entity.common.Contact;
import jp.sourceforge.kuzumeji.entity.common.Contract;
import jp.sourceforge.kuzumeji.entity.common.Credit;
import jp.sourceforge.kuzumeji.entity.common.History;
import jp.sourceforge.kuzumeji.entity.common.Price;
import jp.sourceforge.kuzumeji.entity.common.Role;
import jp.sourceforge.kuzumeji.entity.event.Activity;
import jp.sourceforge.kuzumeji.entity.resource.Company;
import jp.sourceforge.kuzumeji.entity.resource.Group;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import jp.sourceforge.kuzumeji.entity.resource.Unit;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.validator.InvalidStateException;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.framework.EntityHome;
import org.jboss.seam.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonEntityHome<E>
extends EntityHome<E> {
    private static final long serialVersionUID = 4119965886388599851L;
    @Logger
    Log log;
    @RequestParameter
    Long id;
    @In(create=true, required=true)
    private Person mine;
    private boolean removed;
    private String createdMessage = "\u8ffd\u52a0\u3057\u307e\u3057\u305f";
    private String updatedMessage = "\u5909\u66f4\u3057\u307e\u3057\u305f";
    private String deletedMessage = "\u524a\u9664\u3057\u307e\u3057\u305f";
    private static final String MSG_SYSERR = "\u30c7\u30fc\u30bf\u64cd\u4f5c\u3067\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u3092\u691c\u77e5\u3057\u307e\u3057\u305f\u3002\u30b7\u30b9\u30c6\u30e0\u904b\u7528\u8005\u3078\u3054\u9023\u7d61\u304f\u3060\u3055\u3044\u3002";
    private static final String MSG_STSERR = "\u30c7\u30fc\u30bf\u64cd\u4f5c\u3067\u60f3\u5b9a\u5916\u306e\u72b6\u614b\u3092\u691c\u77e5\u3057\u307e\u3057\u305f\u3002\u30b7\u30b9\u30c6\u30e0\u904b\u7528\u8005\u3078\u3054\u9023\u7d61\u304f\u3060\u3055\u3044\u3002";

    public Object getId() {
        return this.id == null ? super.getId() : this.id;
    }

    protected void initInstance() {
        Object mgr;
        super.initInstance();
        if (this.getInstance() instanceof BillManager && (mgr = (BillManager)this.instance).getBill() == null) {
            mgr.setBill(new Bill());
        }
        if (this.getInstance() instanceof BizManager && (mgr = (BizManager)this.instance).getBiz() == null) {
            mgr.setBiz(new Biz());
        }
        if (this.getInstance() instanceof ContactManager && (mgr = (ContactManager)this.instance).getContact() == null) {
            mgr.setContact(new Contact());
        }
        if (this.getInstance() instanceof ContractManager && (mgr = (ContractManager)this.instance).getContract() == null) {
            mgr.setContract(new Contract());
        }
        if (this.getInstance() instanceof CreditManager && (mgr = (CreditManager)this.instance).getCredit() == null) {
            mgr.setCredit(new Credit());
        }
        if (this.getInstance() instanceof PriceManager && (mgr = (PriceManager)this.instance).getPrice() == null) {
            mgr.setPrice(new Price());
        }
        if (this.getInstance() instanceof RoleManager && (mgr = (RoleManager)this.instance).getRole() == null) {
            mgr.setRole(new Role());
        }
    }

    @Begin(join=true)
    public void create() {
        super.create();
    }

    public String persist() {
        String exCause;
        try {
            this.updateRelation();
            if (this.instance instanceof HistoryManager) {
                HistoryManager mgr = (HistoryManager)this.instance;
                mgr.setHistory(new History());
                mgr.getHistory().setOnPersist(this.mine);
            }
            return super.persist();
        }
        catch (EntityExistsException e) {
            super.warn((Object)"persist failed. [#0]", (Throwable)e, new Object[0]);
            exCause = "\u540c\u4e00\u30ad\u30fc\u60c5\u5831\u306e\u30c7\u30fc\u30bf\u304c\u3042\u308b\u305f\u3081\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002";
        }
        catch (ConstraintViolationException e) {
            super.warn((Object)"persist failed. [#0]", (Throwable)e, new Object[0]);
            exCause = "\u30c7\u30fc\u30bf\u64cd\u4f5c\u4e2d\u306b\u5236\u7d04\u9055\u53cd\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
        }
        catch (PersistenceException e) {
            super.warn((Object)"persist failed. [#0]", (Throwable)e, new Object[0]);
            super.info((Object)"\u30c7\u30fc\u30bf\u64cd\u4f5c\u3067\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u3092\u691c\u77e5\u3057\u307e\u3057\u305f\u3002\u30b7\u30b9\u30c6\u30e0\u904b\u7528\u8005\u3078\u3054\u9023\u7d61\u304f\u3060\u3055\u3044\u3002:#0", (Throwable)e, new Object[0]);
            exCause = MSG_SYSERR;
        }
        catch (InvalidStateException e) {
            super.warn((Object)"persist failed. [#0]", (Throwable)e, new Object[0]);
            super.info((Object)"\u30c7\u30fc\u30bf\u64cd\u4f5c\u3067\u60f3\u5b9a\u5916\u306e\u72b6\u614b\u3092\u691c\u77e5\u3057\u307e\u3057\u305f\u3002\u30b7\u30b9\u30c6\u30e0\u904b\u7528\u8005\u3078\u3054\u9023\u7d61\u304f\u3060\u3055\u3044\u3002:#0", (Throwable)e, new Object[0]);
            exCause = MSG_STSERR;
        }
        this.getFacesMessages().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_INFO, this.getCreatedMessageKey(), exCause, new Object[0]);
        return exCause;
    }

    public String update() {
        String exCause;
        try {
            this.updateRelation();
            if (this.instance instanceof HistoryManager) {
                HistoryManager mgr = (HistoryManager)this.instance;
                mgr.getHistory().setOnUpdate(this.mine);
            }
            return super.update();
        }
        catch (EntityExistsException e) {
            super.warn((Object)"update failed. [#0]", (Throwable)e, new Object[0]);
            exCause = "\u540c\u4e00\u30ad\u30fc\u60c5\u5831\u306e\u30c7\u30fc\u30bf\u304c\u3042\u308b\u305f\u3081\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002";
        }
        catch (OptimisticLockException e) {
            super.warn((Object)"update failed. [#0]", (Throwable)e, new Object[0]);
            exCause = "\u4ed6\u306e\u30e6\u30fc\u30b6\u304c\u540c\u4e00\u30c7\u30fc\u30bf\u3092\u5909\u66f4\u3057\u305f\u305f\u3081\u59a5\u5f53\u6027\u3092\u4fdd\u8a3c\u3067\u304d\u307e\u305b\u3093\u3002\u3084\u308a\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        }
        catch (ConstraintViolationException e) {
            super.warn((Object)"update failed. [#0]", (Throwable)e, new Object[0]);
            exCause = "\u30c7\u30fc\u30bf\u64cd\u4f5c\u4e2d\u306b\u5236\u7d04\u9055\u53cd\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
        }
        catch (PersistenceException e) {
            super.warn((Object)"update failed. [#0]", (Throwable)e, new Object[0]);
            exCause = MSG_SYSERR;
        }
        catch (InvalidStateException e) {
            super.warn((Object)"update failed. [#0]", (Throwable)e, new Object[0]);
            exCause = MSG_STSERR;
        }
        this.getFacesMessages().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_INFO, this.getUpdatedMessageKey(), exCause, new Object[0]);
        return exCause;
    }

    public String remove() {
        String exCause;
        try {
            this.removed = true;
            return super.remove();
        }
        catch (EntityExistsException e) {
            super.warn((Object)"remove failed. #0", new Object[]{e.toString()});
            exCause = "\u4ed6\u306e\u30c7\u30fc\u30bf\u304b\u3089\u53c2\u7167\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002\u524a\u9664\u3059\u308b\u306b\u306f\u95a2\u9023\u30c7\u30fc\u30bf\u306e\u53c2\u7167\u524a\u9664\u304c\u5fc5\u8981\u3067\u3059\u3002";
        }
        catch (OptimisticLockException e) {
            super.warn((Object)"remove failed. #0", new Object[]{e.toString()});
            exCause = "\u4ed6\u306e\u30e6\u30fc\u30b6\u304c\u540c\u4e00\u30c7\u30fc\u30bf\u3092\u5909\u66f4\u3057\u305f\u305f\u3081\u59a5\u5f53\u6027\u3092\u4fdd\u8a3c\u3067\u304d\u307e\u305b\u3093\u3002\u3084\u308a\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        }
        catch (ConstraintViolationException e) {
            super.warn((Object)"remove failed. #0", new Object[]{e.toString()});
            exCause = "\u30c7\u30fc\u30bf\u64cd\u4f5c\u4e2d\u306b\u5236\u7d04\u9055\u53cd\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
        }
        catch (EntityNotFoundException e) {
            super.warn((Object)"remove failed. #0", new Object[]{e.toString()});
            exCause = "\u8a72\u5f53\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u304c\u306a\u3044\u305f\u3081\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9 [" + this.getInstance() + "]";
        }
        catch (PersistenceException e) {
            super.warn((Object)"remove failed. #0", new Object[]{e.toString()});
            exCause = MSG_SYSERR;
        }
        catch (InvalidStateException e) {
            super.warn((Object)"remove failed. #0", new Object[]{e.toString()});
            exCause = MSG_STSERR;
        }
        this.getFacesMessages().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_INFO, this.getDeletedMessageKey(), exCause, new Object[0]);
        return exCause;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean aRemoved) {
        this.removed = aRemoved;
    }

    protected void createdMessage() {
        this.debug("created entity #0 #1", new Object[]{this.getEntityClass().getName(), this.id});
        this.getFacesMessages().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_INFO, this.getCreatedMessageKey(), this.createdMessage, new Object[0]);
    }

    protected void updatedMessage() {
        this.debug("updated entity #0 #1", new Object[]{this.getEntityClass().getName(), this.id});
        this.getFacesMessages().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_INFO, this.getUpdatedMessageKey(), this.updatedMessage, new Object[0]);
    }

    protected void deletedMessage() {
        this.debug("deleted entity #0 #1", new Object[]{this.getEntityClass().getName(), this.id});
        this.getFacesMessages().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_INFO, this.getDeletedMessageKey(), this.deletedMessage, new Object[0]);
    }

    protected void updateRelation() {
    }

    public void copyContact2Bill() {
        if (this.instance instanceof BillManager && this.instance instanceof ContactManager) {
            Contact from = ((ContactManager)this.instance).getContact();
            Bill to = ((BillManager)this.instance).getBill();
            to.setName(from.getName());
            to.setZip(from.getZip());
            to.setAddr(from.getAddr());
            to.setUnit(from.getUnit());
            to.setTel(from.getTel());
            to.setFax(from.getFax());
            to.setMail(from.getMail());
            to.setUrl(from.getUrl());
        }
    }

    public Person getPersonByNo(String aNo) {
        try {
            return (Person)this.getEntityManager().createQuery("select p from Person p where p.no=:no").setParameter("no", (Object)aNo).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Unit getUnitByNo(String aNo) {
        try {
            return (Unit)this.getEntityManager().createQuery("select u from Unit u where u.no=:no").setParameter("no", (Object)aNo).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Company getCompanyByNo(String aNo) {
        try {
            return (Company)this.getEntityManager().createQuery("select c from Company c where c.no=:no").setParameter("no", (Object)aNo).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Group getGroupByNo(String aNo) {
        try {
            return (Group)this.getEntityManager().createQuery("select g from Group g where g.no=:no").setParameter("no", (Object)aNo).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Activity getActivityByNo(String aNo) {
        try {
            return (Activity)this.getEntityManager().createQuery("select a from Activity a where a.no=:no").setParameter("no", (Object)aNo).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

