/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.session.conversation.home.event;

import java.util.List;
import jp.sourceforge.kuzumeji.entity.common.MonthlyHeader;
import jp.sourceforge.kuzumeji.entity.common.MonthlyTime;
import jp.sourceforge.kuzumeji.entity.event.Plan;
import jp.sourceforge.kuzumeji.entity.event.PlanPerson;
import jp.sourceforge.kuzumeji.entity.event.PlanPersonMonthly;
import jp.sourceforge.kuzumeji.session.conversation.home.CommonEntityHome;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="planPersonHome")
@Scope(value=ScopeType.CONVERSATION)
public class PlanPersonHome
extends CommonEntityHome<PlanPerson> {
    private static final long serialVersionUID = -374016585932088113L;
    @In
    private Plan thePlan;
    private String employeeNo;

    public String getEmployeeNo() {
        return this.employeeNo;
    }

    public void setEmployeeNo(String aEmployeeNo) {
        this.employeeNo = aEmployeeNo;
    }

    @Override
    protected void initInstance() {
        super.initInstance();
        if (!this.isManaged()) {
            ((PlanPerson)this.instance).setPlan(this.thePlan);
            ((PlanPerson)this.instance).setWork(new MonthlyTime());
        }
    }

    public PlanPerson find() {
        PlanPerson planPerson = (PlanPerson)super.find();
        planPerson.prepareTimes();
        if (planPerson.getPerson() != null) {
            this.employeeNo = planPerson.getPerson().getNo();
        }
        return planPerson;
    }

    @Override
    protected void updateRelation() {
        ((PlanPerson)this.instance).setPerson(super.getPersonByNo(this.employeeNo));
    }

    @Override
    public String persist() {
        this.updateTimes();
        return super.persist();
    }

    @Override
    public String update() {
        this.updateTimes();
        return super.update();
    }

    private void updateTimes() {
        MonthlyTime workTime = ((PlanPerson)this.instance).getWork();
        MonthlyHeader header = ((PlanPerson)this.instance).getPlan().getHeader();
        List<PlanPersonMonthly> ppms = ((PlanPerson)this.instance).getTimes();
        if (ppms.size() < 12) {
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
            ppms.add(new PlanPersonMonthly());
        }
        for (PlanPersonMonthly ppm : ppms) {
            ppm.setPlanPerson((PlanPerson)this.instance);
        }
        ppms.get(0).setYm(header.getYm01());
        ppms.get(0).setTime(workTime.getT01());
        ppms.get(1).setYm(header.getYm02());
        ppms.get(1).setTime(workTime.getT02());
        ppms.get(2).setYm(header.getYm03());
        ppms.get(2).setTime(workTime.getT03());
        ppms.get(3).setYm(header.getYm04());
        ppms.get(3).setTime(workTime.getT04());
        ppms.get(4).setYm(header.getYm05());
        ppms.get(4).setTime(workTime.getT05());
        ppms.get(5).setYm(header.getYm06());
        ppms.get(5).setTime(workTime.getT06());
        ppms.get(6).setYm(header.getYm07());
        ppms.get(6).setTime(workTime.getT07());
        ppms.get(7).setYm(header.getYm08());
        ppms.get(7).setTime(workTime.getT08());
        ppms.get(8).setYm(header.getYm09());
        ppms.get(8).setTime(workTime.getT09());
        ppms.get(9).setYm(header.getYm10());
        ppms.get(9).setTime(workTime.getT10());
        ppms.get(10).setYm(header.getYm11());
        ppms.get(10).setTime(workTime.getT11());
        ppms.get(11).setYm(header.getYm12());
        ppms.get(11).setTime(workTime.getT12());
        ((PlanPerson)this.instance).setTimes(ppms);
    }

    @Override
    public String remove() {
        return super.remove();
    }
}

