/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.session.conversation.query.event;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.NoResultException;
import jp.sourceforge.kuzumeji.entity.event.Do;
import jp.sourceforge.kuzumeji.session.conversation.query.event.DoList;
import jp.sourceforge.kuzumeji.session.conversation.query.resource.ParamList;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.security.Restrict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="checkList")
@Scope(value=ScopeType.EVENT)
@Restrict(value="#{identity.loggedIn}")
public class CheckList
extends DoList {
    private static final long serialVersionUID = -6541063213749374254L;
    @In(required=false)
    private String activityNo = "";
    @In(required=false)
    private String employeeNo = "";
    @In(create=true, required=false)
    private ParamList paramList;

    @Override
    public String getEjbql() {
        String period = this.paramList.getPeriod();
        String ql = String.format("select d from Do d where d.ym = '%s' and d.activity.no like #{patternActivityNo} and d.person.no like #{patternEmployeeNo} order by d.activity.no", period);
        super.debug((Object)"Query is #0,ym is #1,activityNo is #2,employeeNo is #3", new Object[]{ql, period, this.activityNo, this.employeeNo});
        return ql;
    }

    @Factory(value="patternActivityNo", scope=ScopeType.EVENT)
    public String getActivityNo() {
        super.debug((Object)"super.getSearchPattern(this.activityNo) is #0", new Object[]{super.getSearchPattern(this.activityNo)});
        return super.getSearchPattern(this.activityNo);
    }

    @Factory(value="patternEmployeeNo", scope=ScopeType.EVENT)
    public String getEmployeeNo() {
        return super.getSearchPattern(this.employeeNo);
    }

    public boolean isCanApproveTime() {
        for (Do doit : this.getResultList()) {
            if (!doit.isConfirmTime()) {
                return false;
            }
            String sts = doit.getCheckTimeSts();
            if (sts.equals("\u7d4c\u7406\u627f\u8a8d")) continue;
            return true;
        }
        return false;
    }

    public boolean isCanApproveExpense() {
        for (Do doit : this.getResultList()) {
            if (!doit.isConfirmExpense()) {
                return false;
            }
            if (!doit.isConfirmProject()) {
                return false;
            }
            if (!doit.isConfirmPartner()) {
                return false;
            }
            String sts = doit.getCheckExpenseSts();
            if (sts.equals("\u7d4c\u7406\u627f\u8a8d")) continue;
            return true;
        }
        return false;
    }

    public void approveTime() {
        this.getEntityManager().joinTransaction();
        for (Do doit : this.getResultList()) {
            String sts;
            if (!doit.isMarked() || (sts = doit.getCheckTimeSts()) == null) continue;
            if (sts.equals("\u672a\u627f\u8a8d")) {
                doit.setCheckTimeSts("PM\u627f\u8a8d");
                continue;
            }
            if (sts.equals("PM\u627f\u8a8d")) {
                doit.setCheckTimeSts("LM\u627f\u8a8d");
                continue;
            }
            if (sts.equals("LM\u627f\u8a8d")) {
                doit.setCheckTimeSts("\u7d4c\u7406\u627f\u8a8d");
                continue;
            }
            if (!sts.equals("\u7d4c\u7406\u627f\u8a8d") && !sts.equals("\u5dee\u623b")) continue;
        }
        this.getEntityManager().flush();
    }

    public void rejectTime() {
        this.getEntityManager().joinTransaction();
        HashSet<String> persons = new HashSet<String>();
        for (Do doit : this.getResultList()) {
            String sts;
            if (!doit.isMarked() || (sts = doit.getCheckTimeSts()) == null || sts.equals("\u7d4c\u7406\u627f\u8a8d") || sts.equals("\u5dee\u623b")) continue;
            persons.add(doit.getPerson().getNo());
        }
        for (String personNo : persons) {
            List<Do> dos = this.getDoByPersonNo(personNo);
            for (Do doit : dos) {
                doit.setCheckTimeSts("\u5dee\u623b");
                doit.setRejectTimeDate(new Date());
            }
        }
        this.getEntityManager().flush();
    }

    public void approveExpense() {
        this.getEntityManager().joinTransaction();
        for (Do doit : this.getResultList()) {
            String sts;
            if (!doit.isMarked() || (sts = doit.getCheckExpenseSts()) == null) continue;
            if (sts.equals("\u672a\u627f\u8a8d")) {
                doit.setCheckExpenseSts("PM\u627f\u8a8d");
                continue;
            }
            if (sts.equals("PM\u627f\u8a8d")) {
                doit.setCheckExpenseSts("LM\u627f\u8a8d");
                continue;
            }
            if (sts.equals("LM\u627f\u8a8d")) {
                doit.setCheckExpenseSts("\u7d4c\u7406\u627f\u8a8d");
                continue;
            }
            if (!sts.equals("\u7d4c\u7406\u627f\u8a8d") && !sts.equals("\u5dee\u623b")) continue;
        }
        this.getEntityManager().flush();
    }

    public void rejectExpense() {
        this.getEntityManager().joinTransaction();
        HashSet<String> persons = new HashSet<String>();
        for (Do doit : this.getResultList()) {
            String sts;
            if (!doit.isMarked() || (sts = doit.getCheckExpenseSts()) == null || sts.equals("\u7d4c\u7406\u627f\u8a8d") || sts.equals("\u5dee\u623b")) continue;
            persons.add(doit.getPerson().getNo());
        }
        for (String personNo : persons) {
            List<Do> dos = this.getDoByPersonNo(personNo);
            for (Do doit : dos) {
                doit.setCheckExpenseSts("\u5dee\u623b");
                doit.setRejectExpenseDate(new Date());
            }
        }
        this.getEntityManager().flush();
    }

    public void setMark() {
        for (Do doit : this.getResultList()) {
            doit.setMarked(true);
        }
    }

    public void clearMark() {
        for (Do doit : this.getResultList()) {
            doit.setMarked(false);
        }
    }

    private List<Do> getDoByPersonNo(String aPersonNo) {
        try {
            String ql = String.format("select d from Do d where d.ym='%s' and d.person.no='%s'", this.paramList.getPeriod(), aPersonNo);
            return this.getEntityManager().createQuery(ql).getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<Do>();
        }
    }
}

