/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.session.conversation.query.event;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.faces.model.SelectItem;
import jp.sourceforge.kuzumeji.entity.event.Activity;
import jp.sourceforge.kuzumeji.entity.event.Do;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import jp.sourceforge.kuzumeji.session.conversation.query.CommonEntityQuery;
import jp.sourceforge.kuzumeji.session.conversation.query.resource.ParamList;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="doList")
@Scope(value=ScopeType.EVENT)
@Restrict(value="#{identity.loggedIn}")
public class DoList
extends CommonEntityQuery<Do> {
    private static final long serialVersionUID = -6846709560910616424L;
    @Logger
    Log log;
    @In(create=true, required=true)
    private Person mine;
    @In(create=true, required=false)
    private ParamList paramList;

    public String getEjbql() {
        String personNo = this.mine.getNo();
        String period = this.paramList.getPeriod();
        String ql = String.format("select d from Do d where d.person.no = '%s' and d.ym = '%s' order by d.activity.no", personNo, period);
        return ql;
    }

    public Do getDoById(long aId) {
        for (Do doit : super.getResultList()) {
            if (doit.getId() != aId) continue;
            return doit;
        }
        return null;
    }

    public List<SelectItem> getActivitys() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (Do doit : super.getResultList()) {
            Activity a = doit.getActivity();
            items.add(new SelectItem((Object)doit.getId(), a.getNo() + "/" + a.getAlias()));
        }
        return items;
    }

    public String getCheckTimeSts() {
        TreeSet<String> stss = new TreeSet<String>();
        for (Do doit : this.getResultList()) {
            if (doit.getCheckTimeSts() == null) {
                stss.add("N/A");
                continue;
            }
            stss.add(doit.getCheckTimeSts());
        }
        StringBuffer buf = new StringBuffer();
        for (String sts : stss) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(sts);
        }
        return buf.toString();
    }

    public String getCheckExpenseSts() {
        TreeSet<String> stss = new TreeSet<String>();
        for (Do doit : this.getResultList()) {
            if (doit.getCheckExpenseSts() == null) {
                stss.add("N/A");
                continue;
            }
            stss.add(doit.getCheckExpenseSts());
        }
        StringBuffer buf = new StringBuffer();
        for (String sts : stss) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(sts);
        }
        return buf.toString();
    }

    public boolean isCanConfirmTime() {
        for (Do doit : this.getResultList()) {
            if (!doit.isConfirmTime()) continue;
            return false;
        }
        return true;
    }

    public boolean isCanCancelTime() {
        if (this.isCanConfirmTime()) {
            return false;
        }
        for (Do doit : this.getResultList()) {
            String sts = doit.getCheckTimeSts();
            if (sts == null || !sts.equals("PM\u627f\u8a8d") && !sts.equals("LM\u627f\u8a8d") && !sts.equals("\u7d4c\u7406\u627f\u8a8d")) continue;
            return false;
        }
        return true;
    }

    public boolean isCanConfirmExpense() {
        for (Do doit : this.getResultList()) {
            if (!doit.isConfirmExpense()) continue;
            return false;
        }
        return true;
    }

    public boolean isCanConfirmProject() {
        for (Do doit : this.getResultList()) {
            if (!doit.isConfirmProject()) continue;
            return false;
        }
        return true;
    }

    public boolean isCanConfirmPartner() {
        for (Do doit : this.getResultList()) {
            if (!doit.isConfirmPartner()) continue;
            return false;
        }
        return true;
    }

    public boolean isCanCancelExpense() {
        for (Do doit : this.getResultList()) {
            String sts = doit.getCheckExpenseSts();
            if (sts == null || !sts.equals("PM\u627f\u8a8d") && !sts.equals("LM\u627f\u8a8d") && !sts.equals("\u7d4c\u7406\u627f\u8a8d")) continue;
            return false;
        }
        return true;
    }

    public void confirmTime() {
        this.setConfirmTime(true);
    }

    public void cancelTime() {
        this.setConfirmTime(false);
    }

    private void setConfirmTime(boolean aConfirm) {
        this.getEntityManager().joinTransaction();
        for (Do doit : this.getResultList()) {
            doit.setConfirmTime(aConfirm);
            doit.setCheckTimeSts(aConfirm ? "\u672a\u627f\u8a8d" : null);
            if (!aConfirm) continue;
            doit.setConfirmTimeDate(new Date());
        }
        this.getEntityManager().flush();
    }

    public void confirmExpense() {
        this.setConfirmExpense(true);
        this.initCheckExpenseSts();
    }

    public void cancelExpense() {
        this.setConfirmExpense(false);
    }

    private void setConfirmExpense(boolean aConfirm) {
        this.getEntityManager().joinTransaction();
        for (Do doit : this.getResultList()) {
            doit.setConfirmExpense(aConfirm);
            if (!aConfirm) continue;
            doit.setConfirmExpenseDate(new Date());
        }
        this.getEntityManager().flush();
    }

    public void confirmProject() {
        this.setConfirmProject(true);
        this.initCheckExpenseSts();
    }

    public void cancelProject() {
        this.setConfirmProject(false);
    }

    private void setConfirmProject(boolean aConfirm) {
        this.getEntityManager().joinTransaction();
        for (Do doit : this.getResultList()) {
            doit.setConfirmProject(aConfirm);
            if (!aConfirm) continue;
            doit.setConfirmProjectDate(new Date());
        }
        this.getEntityManager().flush();
    }

    public void confirmPartner() {
        this.setConfirmPartner(true);
        this.initCheckExpenseSts();
    }

    public void cancelPartner() {
        this.setConfirmPartner(false);
    }

    private void setConfirmPartner(boolean aConfirm) {
        this.getEntityManager().joinTransaction();
        for (Do doit : this.getResultList()) {
            doit.setConfirmPartner(aConfirm);
            if (!aConfirm) continue;
            doit.setConfirmPartnerDate(new Date());
        }
        this.getEntityManager().flush();
    }

    private void initCheckExpenseSts() {
        super.debug((Object)"\u7d4c\u8cbb\u78ba\u8a8d\u72b6\u6cc1\u3078\u78ba\u8a8d\u4e2d", new Object[0]);
        for (Do doit : this.getResultList()) {
            if (!doit.isConfirmExpense()) {
                return;
            }
            if (!doit.isConfirmProject()) {
                return;
            }
            if (doit.isConfirmPartner()) continue;
            return;
        }
        super.debug((Object)"\u672a\u627f\u8a8d\u3078\u5909\u66f4\u4e2d", new Object[0]);
        this.getEntityManager().joinTransaction();
        for (Do doit : this.getResultList()) {
            doit.setCheckExpenseSts("\u672a\u627f\u8a8d");
        }
        this.getEntityManager().flush();
    }

    public Date getConfirmTimeDate() {
        TreeSet<Date> dates = new TreeSet<Date>();
        for (Do doit : this.getResultList()) {
            if (doit.getConfirmTimeDate() == null) continue;
            dates.add(doit.getConfirmTimeDate());
        }
        return dates.size() > 0 ? (Date)dates.last() : null;
    }

    public Date getConfirmExpenseDate() {
        TreeSet<Date> dates = new TreeSet<Date>();
        for (Do doit : this.getResultList()) {
            if (doit.getConfirmExpenseDate() == null) continue;
            dates.add(doit.getConfirmExpenseDate());
        }
        return dates.size() > 0 ? (Date)dates.last() : null;
    }

    public Date getConfirmProjectDate() {
        TreeSet<Date> dates = new TreeSet<Date>();
        for (Do doit : this.getResultList()) {
            if (doit.getConfirmProjectDate() == null) continue;
            dates.add(doit.getConfirmProjectDate());
        }
        return dates.size() > 0 ? (Date)dates.last() : null;
    }

    public Date getConfirmPartnerDate() {
        TreeSet<Date> dates = new TreeSet<Date>();
        for (Do doit : this.getResultList()) {
            if (doit.getConfirmPartnerDate() == null) continue;
            dates.add(doit.getConfirmPartnerDate());
        }
        return dates.size() > 0 ? (Date)dates.last() : null;
    }

    public Date getRejectTimeDate() {
        TreeSet<Date> dates = new TreeSet<Date>();
        for (Do doit : this.getResultList()) {
            if (doit.getRejectTimeDate() == null) continue;
            dates.add(doit.getRejectTimeDate());
        }
        return dates.size() > 0 ? (Date)dates.last() : null;
    }

    public Date getRejectExpenseDate() {
        TreeSet<Date> dates = new TreeSet<Date>();
        for (Do doit : this.getResultList()) {
            if (doit.getRejectExpenseDate() == null) continue;
            dates.add(doit.getRejectExpenseDate());
        }
        return dates.size() > 0 ? (Date)dates.last() : null;
    }
}

