/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.session.conversation.query.event;

import java.util.List;
import javax.persistence.NoResultException;
import jp.sourceforge.kuzumeji.entity.event.PlanPerson;
import jp.sourceforge.kuzumeji.entity.resource.DefaultPrice;
import jp.sourceforge.kuzumeji.session.conversation.query.event.ActivitySelectedList;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.security.Restrict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="planPersonList")
@Scope(value=ScopeType.EVENT)
@Restrict(value="#{identity.loggedIn}")
public class PlanPersonList
extends ActivitySelectedList<PlanPerson> {
    private static final long serialVersionUID = -8377512040350305776L;

    public String getEjbql() {
        String ql = String.format("select pp from PlanPerson pp where pp.plan.activity.no = '%s'  and pp.plan.activity.startYmd is not null order by pp.plan.activity.no", this.activityNo);
        return ql;
    }

    @Override
    public List<PlanPerson> getResultList() {
        List<PlanPerson> planPersons = super.getResultList();
        for (PlanPerson planPerson : planPersons) {
            planPerson.prepareTimes();
            DefaultPrice price = null;
            try {
                price = (DefaultPrice)this.getEntityManager().createQuery("select dp from DefaultPrice dp where dp.jobRank=:jobRank and dp.activityCat=:activityCat").setParameter("jobRank", (Object)planPerson.getPerson().getJobRank()).setParameter("activityCat", (Object)planPerson.getPlan().getActivity().getCat()).getSingleResult();
            }
            catch (NoResultException e) {
                // empty catch block
            }
            if (price == null) continue;
            planPerson.setDefaultCostPrice(price.getPrice().getCost());
            planPerson.setDefaultUnitPrice(price.getPrice().getUnit());
        }
        return planPersons;
    }
}

