/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.kuzumeji.session.form;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import jp.sourceforge.kuzumeji.entity.event.Activity;
import jp.sourceforge.kuzumeji.entity.resource.Company;
import jp.sourceforge.kuzumeji.entity.resource.Group;
import jp.sourceforge.kuzumeji.entity.resource.Person;
import jp.sourceforge.kuzumeji.entity.resource.Unit;
import jp.sourceforge.kuzumeji.session.form.MapBean;
import jp.sourceforge.kuzumeji.session.form.SuggestForm;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateful
@Local
@Name(value="suggestForm")
@Scope(value=ScopeType.SESSION)
public class SuggestFormBean
implements SuggestForm {
    @Logger
    Log log;
    @PersistenceContext
    EntityManager em;

    @Override
    public List<MapBean> regulars(Object aEvent) {
        String hint = aEvent.toString();
        String ql = String.format("select p from Person p where (p.cat = '\u6b63\u793e\u54e1' or p.cat = '\u5951\u7d04\u793e\u54e1') and (p.no like '%%%s%%' or p.name like '%%%s%%' or p.kana like '%%%s%%') order by p.no", hint, hint, hint);
        return this.getPersonsByQl(ql);
    }

    @Override
    public List<MapBean> persons(Object aEvent) {
        String hint = aEvent.toString();
        String ql = String.format("select p from Person p where (p.no like '%%%s%%' or p.name like '%%%s%%' or p.kana like '%%%s%%') order by p.no", hint, hint, hint);
        return this.getPersonsByQl(ql);
    }

    private List<MapBean> getPersonsByQl(String aQl) {
        try {
            List persons = this.em.createQuery(aQl).getResultList();
            ArrayList<MapBean> regulars = new ArrayList<MapBean>(0);
            for (Person person : persons) {
                MapBean map = new MapBean();
                map.setNo(person.getNo());
                map.setName(person.getName());
                regulars.add(map);
            }
            return regulars;
        }
        catch (NoResultException e) {
            return new ArrayList<MapBean>(0);
        }
    }

    @Override
    public List<MapBean> companys(Object aEvent) {
        String hint = aEvent.toString();
        String ql = String.format("select c from Company c where (c.no like '%%%s%%' or c.alias like '%%%s%%' or c.name like '%%%s%%' or c.kana like '%%%s%%' or c.product like '%%%s%%' or c.note like '%%%s%%') order by c.no", hint, hint, hint, hint, hint, hint);
        try {
            List companys = this.em.createQuery(ql).getResultList();
            ArrayList<MapBean> regulars = new ArrayList<MapBean>(0);
            for (Company company : companys) {
                MapBean map = new MapBean();
                map.setNo(company.getNo());
                map.setName(company.getName());
                regulars.add(map);
            }
            return regulars;
        }
        catch (NoResultException e) {
            return new ArrayList<MapBean>(0);
        }
    }

    @Override
    public List<MapBean> groups(Object aEvent) {
        String hint = aEvent.toString();
        String ql = String.format("select g from Group g where (g.no like '%%%s%%' or g.name like '%%%s%%') order by g.no", hint, hint);
        try {
            List groups = this.em.createQuery(ql).getResultList();
            ArrayList<MapBean> regulars = new ArrayList<MapBean>(0);
            for (Group group : groups) {
                MapBean map = new MapBean();
                map.setNo(group.getNo());
                map.setName(group.getName());
                regulars.add(map);
            }
            return regulars;
        }
        catch (NoResultException e) {
            return new ArrayList<MapBean>(0);
        }
    }

    @Override
    public List<MapBean> activitys(Object aEvent) {
        String hint = aEvent.toString();
        String ql = String.format("select a from Activity a where (a.no like '%%%s%%' or a.alias like '%%%s%%' or a.name like '%%%s%%' or a.digest like '%%%s%%' or a.project like '%%%s%%' or a.phase like '%%%s%%') order by a.no", hint, hint, hint, hint, hint, hint);
        try {
            List activitys = this.em.createQuery(ql).getResultList();
            ArrayList<MapBean> regulars = new ArrayList<MapBean>(0);
            for (Activity activity : activitys) {
                MapBean map = new MapBean();
                map.setNo(activity.getNo());
                map.setName(activity.getName());
                regulars.add(map);
            }
            return regulars;
        }
        catch (NoResultException e) {
            return new ArrayList<MapBean>(0);
        }
    }

    @Override
    public List<MapBean> units(Object aEvent) {
        String hint = aEvent.toString();
        String ql = String.format("select u from Unit u where (u.no like '%%%s%%' or u.name like '%%%s%%') order by u.no", hint, hint);
        try {
            List units = this.em.createQuery(ql).getResultList();
            ArrayList<MapBean> regulars = new ArrayList<MapBean>(0);
            for (Unit unit : units) {
                MapBean map = new MapBean();
                map.setNo(unit.getNo());
                map.setName(unit.getName());
                regulars.add(map);
            }
            return regulars;
        }
        catch (NoResultException e) {
            return new ArrayList<MapBean>(0);
        }
    }

    @Override
    public List<MapBean> projects(Object aEvent) {
        String hint = aEvent.toString();
        String ql = String.format("select a from Activity a where (a.company.no like '%%%s%%' or a.company.alias like '%%%s%%' or a.company.name like '%%%s%%' or a.company.kana like '%%%s%%' or a.project like '%%%s%%') order by a.company.no, a.project", hint, hint, hint, hint, hint);
        try {
            List activities = this.em.createQuery(ql).getResultList();
            ArrayList<MapBean> projects = new ArrayList<MapBean>(0);
            String no = null;
            String project = null;
            for (Activity activity : activities) {
                if (no == null || project == null || !no.equals(activity.getCompany().getNo()) || !project.equals(activity.getProject())) {
                    MapBean map = new MapBean();
                    map.setNo(activity.getProject());
                    map.setName(activity.getCompany().getNo() + "/" + activity.getProject());
                    projects.add(map);
                }
                no = activity.getCompany().getNo();
                project = activity.getProject();
            }
            return projects;
        }
        catch (NoResultException e) {
            return new ArrayList<MapBean>(0);
        }
    }

    @Override
    public List<MapBean> phases(Object aEvent) {
        String hint = aEvent.toString();
        String ql = String.format("select a from Activity a where (a.company.no like '%%%s%%' or a.company.alias like '%%%s%%' or a.company.name like '%%%s%%' or a.company.kana like '%%%s%%' or a.phase like '%%%s%%') order by a.company.no, a.phase", hint, hint, hint, hint, hint);
        try {
            List activities = this.em.createQuery(ql).getResultList();
            ArrayList<MapBean> phases = new ArrayList<MapBean>(0);
            String no = null;
            String phase = null;
            for (Activity activity : activities) {
                if (no == null || phase == null || !no.equals(activity.getCompany().getNo()) || !phase.equals(activity.getPhase())) {
                    MapBean map = new MapBean();
                    map.setNo(activity.getPhase());
                    map.setName(activity.getCompany().getNo() + "/" + activity.getPhase());
                    phases.add(map);
                }
                no = activity.getCompany().getNo();
                phase = activity.getPhase();
            }
            return phases;
        }
        catch (NoResultException e) {
            return new ArrayList<MapBean>(0);
        }
    }

    @Override
    public List<MapBean> teams(Object aEvent) {
        String hint = aEvent.toString();
        String ql = String.format("select p from Person p where (p.cat = '\u6b63\u793e\u54e1' or p.cat = '\u5951\u7d04\u793e\u54e1') and (p.unit.no like '%%%s%%' or p.unit.name like '%%%s%%' or p.team like '%%%s%%') order by p.unit.no, p.team", hint, hint, hint);
        try {
            List persons = this.em.createQuery(ql).getResultList();
            ArrayList<MapBean> phases = new ArrayList<MapBean>(0);
            String no = null;
            String team = null;
            for (Person person : persons) {
                if (no == null || team == null || !no.equals(person.getUnit().getNo()) || !team.equals(person.getTeam())) {
                    MapBean map = new MapBean();
                    map.setNo(person.getTeam());
                    map.setName(person.getUnit().getNo() + "/" + person.getTeam());
                    phases.add(map);
                }
                no = person.getUnit().getNo();
                team = person.getTeam();
            }
            return phases;
        }
        catch (NoResultException e) {
            return new ArrayList<MapBean>(0);
        }
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
    }
}

