/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.regex.Pattern;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.FastTokenIterator;
import org.mvel.Soundex;
import org.mvel.Token;
import org.mvel.TokenIterator;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ExecutionStack;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.Stack;
import org.mvel.util.StringAppender;

public class AcceleratedParser
extends AbstractParser {
    private final TokenIterator tokens;
    private final Stack stk = new ExecutionStack();

    public AcceleratedParser(FastTokenIterator tokens) {
        this.tokens = new FastTokenIterator(tokens);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object execute(Object ctx, VariableResolverFactory variableFactory) {
        Token tk;
        block5: while ((tk = this.tokens.nextToken()) != null) {
            if (this.stk.isEmpty()) {
                this.stk.push(tk.getReducedValueAccelerated(ctx, ctx, variableFactory));
            }
            if (!tk.isOperator()) continue;
            Integer operator = tk.getOperator();
            switch (this.reduceBinary(operator)) {
                case -1: {
                    return this.stk.pop();
                }
                case 0: {
                    break;
                }
                case 1: {
                    continue block5;
                }
            }
            this.stk.push(this.tokens.nextToken().getReducedValueAccelerated(ctx, ctx, variableFactory), operator);
            this.reduceTrinary();
        }
        return this.stk.peek();
    }

    private int reduceBinary(int o) {
        switch (o) {
            case 12: {
                if (this.stk.peek() instanceof Boolean && !((Boolean)this.stk.peek()).booleanValue()) {
                    if (this.unwindStatement()) {
                        return -1;
                    }
                    this.stk.clear();
                    return 1;
                }
                this.stk.discard();
                return 1;
            }
            case 13: {
                if (this.stk.peek() instanceof Boolean && ((Boolean)this.stk.peek()).booleanValue()) {
                    if (this.unwindStatement()) {
                        return -1;
                    }
                    this.stk.clear();
                    return 1;
                }
                this.stk.discard();
                return 1;
            }
            case 28: {
                if (!((Boolean)this.stk.pop()).booleanValue()) {
                    this.skipToOperator(29);
                }
                this.stk.clear();
                return 1;
            }
            case 29: {
                return -1;
            }
            case 36: {
                if (!this.hasNoMore()) {
                    this.stk.clear();
                }
                return 1;
            }
        }
        return 0;
    }

    private void reduceTrinary() {
        Object v1 = null;
        try {
            while (this.stk.size() > 1) {
                Integer operator = (Integer)this.stk.pop();
                v1 = this.stk.pop();
                Object v2 = this.stk.pop();
                switch (operator) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.stk.push(ParseTools.doOperations(v2, operator, v1));
                        break;
                    }
                    case 14: {
                        if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                            this.stk.clear();
                            this.stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                            return;
                        }
                        this.stk.push(null);
                        break;
                    }
                    case 15: {
                        this.stk.push(new Boolean(Pattern.compile(String.valueOf(v1)).matcher(String.valueOf(v2)).matches()));
                        break;
                    }
                    case 16: {
                        if (v1 instanceof Class) {
                            this.stk.push(new Boolean(((Class)v1).isInstance(v2)));
                            break;
                        }
                        this.stk.push(new Boolean(Class.forName(String.valueOf(v1)).isInstance(v2)));
                        break;
                    }
                    case 35: {
                        if (v1 instanceof Class) {
                            this.stk.push(new Boolean(DataConversion.canConvert(v2.getClass(), (Class)v1)));
                            break;
                        }
                        this.stk.push(new Boolean(DataConversion.canConvert(v2.getClass(), Class.forName(String.valueOf(v1)))));
                        break;
                    }
                    case 17: {
                        this.stk.push(new Boolean(ParseTools.containsCheck(v2, v1)));
                        break;
                    }
                    case 21: {
                        this.stk.push(new Integer(AcceleratedParser.asInt(v2) & AcceleratedParser.asInt(v1)));
                        break;
                    }
                    case 22: {
                        this.stk.push(new Integer(AcceleratedParser.asInt(v2) | AcceleratedParser.asInt(v1)));
                        break;
                    }
                    case 23: {
                        this.stk.push(new Integer(AcceleratedParser.asInt(v2) ^ AcceleratedParser.asInt(v1)));
                        break;
                    }
                    case 25: {
                        this.stk.push(new Integer(AcceleratedParser.asInt(v2) << AcceleratedParser.asInt(v1)));
                        break;
                    }
                    case 27: {
                        int iv2 = AcceleratedParser.asInt(v2);
                        if (iv2 < 0) {
                            iv2 *= -1;
                        }
                        this.stk.push(new Integer(iv2 << AcceleratedParser.asInt(v1)));
                        break;
                    }
                    case 24: {
                        this.stk.push(new Integer(AcceleratedParser.asInt(v2) >> AcceleratedParser.asInt(v1)));
                        break;
                    }
                    case 26: {
                        this.stk.push(new Integer(AcceleratedParser.asInt(v2) >>> AcceleratedParser.asInt(v1)));
                        break;
                    }
                    case 18: {
                        this.stk.push(new StringAppender(String.valueOf(v2)).append(String.valueOf(v1)).toString());
                        break;
                    }
                    case 19: {
                        this.stk.push(new Boolean(Soundex.soundex(String.valueOf(v1)).equals(Soundex.soundex(String.valueOf(v2)))));
                        break;
                    }
                    case 20: {
                        this.stk.push(new Float(PropertyTools.similarity(String.valueOf(v1), String.valueOf(v2))));
                    }
                }
            }
        }
        catch (ClassCastException e) {
            if ((this.fields & 0x2000) == 0) {
                this.fields |= 0x2000;
                Token tk = this.nextToken();
                if (tk != null) {
                    this.stk.push(v1, this.nextToken(), tk.getOperator());
                    this.reduceTrinary();
                    return;
                }
            }
            throw new CompileException("syntax error or incomptable types", this.expr, this.cursor, e);
        }
        catch (Exception e) {
            throw new CompileException("failed to subEval expression", e);
        }
    }

    private static int asInt(Object o) {
        return (Integer)o;
    }

    private boolean hasNoMore() {
        return !this.tokens.hasMoreTokens();
    }

    private boolean unwindStatement() {
        while (this.tokens.hasMoreTokens() && !this.tokens.nextToken().isOperator(new Integer(36))) {
        }
        return !this.tokens.hasMoreTokens();
    }

    private void skipToOperator(int operator) {
        while (this.tokens.hasMoreTokens() && !this.tokens.nextToken().isOperator(new Integer(operator))) {
        }
    }
}

