/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

public class CompileException
extends RuntimeException {
    private char[] expr;
    private int cursor;

    public CompileException() {
    }

    public CompileException(String message) {
        super(message);
    }

    public CompileException(String message, char[] expr, int cursor, Exception e) {
        super("Failed to compile:\n[Error: " + message + "]\n[Near: \"" + CompileException.showCodeNearError(expr, cursor) + "\"]", e);
        this.expr = expr;
        this.cursor = cursor;
    }

    public CompileException(String message, char[] expr, int cursor) {
        super("Failed to compile:\n[Error: " + message + "]\n[Near: \"" + CompileException.showCodeNearError(expr, cursor) + "\"]");
        this.expr = expr;
        this.cursor = cursor;
    }

    public CompileException(String message, Throwable cause) {
        super(message, cause);
    }

    public CompileException(Throwable cause) {
        super(cause);
    }

    private static CharSequence showCodeNearError(char[] expr, int cursor) {
        if (expr == null) {
            return "Unknown";
        }
        int start = cursor - 10;
        int end = cursor + 20;
        if (start < 0) {
            start = 0;
        }
        if (end > expr.length) {
            end = expr.length - 1;
        }
        return "'" + String.copyValueOf(expr, start, end - start) + "'";
    }

    public char[] getExpr() {
        return this.expr;
    }

    public int getCursor() {
        return this.cursor;
    }
}

