/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.CompiledExpression;
import org.mvel.DataConversion;
import org.mvel.FastTokenIterator;
import org.mvel.PropertyVerifier;
import org.mvel.Soundex;
import org.mvel.Token;
import org.mvel.TokenSet;
import org.mvel.util.ExecutionStack;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.Stack;
import org.mvel.util.StringAppender;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionCompiler
extends AbstractParser {
    private final Stack stk = new ExecutionStack();
    private List<String> inputs;
    private List<String> locals;

    public CompiledExpression compile(boolean verifying) {
        Token tk;
        TokenSet tokenSet = new TokenSet();
        if (verifying) {
            this.inputs = new LinkedList<String>();
            this.locals = new LinkedList<String>();
        }
        while ((tk = this.nextToken()) != null) {
            if (tk.isSubeval()) {
                ExpressionCompiler subCompiler = new ExpressionCompiler(tk.getNameAsArray());
                tk.setAccessor(subCompiler.compile(verifying));
                if (verifying) {
                    this.inputs.addAll(subCompiler.getInputs());
                }
            }
            if (tk.isLiteral() && tk.getLiteralValue() != LITERALS.get("this")) {
                Token tkOp = this.nextToken();
                if (tkOp != null && tkOp.isOperator() && !tkOp.isOperator(new Integer(28)) && !tkOp.isOperator(new Integer(29))) {
                    Token tkLA = this.nextToken();
                    if (tkLA != null && tkLA.isLiteral()) {
                        this.stk.push(tk.getLiteralValue(), tkLA.getLiteralValue(), tkOp.getLiteralValue());
                        this.reduceTrinary();
                        boolean firstLA = true;
                        while ((tkOp = this.nextToken()) != null) {
                            Token tkLA2 = this.nextToken();
                            if (tkLA2 != null && tkLA2.isLiteral()) {
                                this.stk.push(tkLA2.getLiteralValue(), tkOp.getLiteralValue());
                                this.reduceTrinary();
                                firstLA = false;
                                continue;
                            }
                            if (firstLA) {
                                tokenSet.addTokenNode(new Token(1, this.stk.pop()));
                                break;
                            }
                            tokenSet.addTokenNode(new Token(1, this.stk.pop()), tkOp);
                            if (tkLA2 == null) break;
                            tokenSet.addTokenNode(tkLA2);
                            break;
                        }
                        if (this.stk.isEmpty()) continue;
                        tokenSet.addTokenNode(new Token(1, this.stk.pop()));
                        continue;
                    }
                    tokenSet.addTokenNode(tk, tkOp);
                    if (tkLA == null) continue;
                    tokenSet.addTokenNode(tkLA);
                    continue;
                }
                tokenSet.addTokenNode(tk);
                if (tkOp == null) continue;
                tokenSet.addTokenNode(tkOp);
                continue;
            }
            if (verifying) {
                if (tk.isAssignment()) {
                    char[] assign = tk.getNameAsArray();
                    int c = 0;
                    while (c < assign.length && assign[c] != '=') {
                        ++c;
                    }
                    this.locals.add(new String(assign, 0, c++).trim());
                    ExpressionCompiler subCompiler = new ExpressionCompiler(new String(assign, c, assign.length - c).trim());
                    subCompiler.compile(true);
                    this.inputs.addAll(subCompiler.getInputs());
                } else if (tk.isIdentifier()) {
                    this.inputs.add(tk.getAbsoluteName());
                    PropertyVerifier propVerifier = new PropertyVerifier(tk.getNameAsArray());
                    propVerifier.analyze();
                    this.inputs.addAll(propVerifier.getInputs());
                }
            }
            tokenSet.addTokenNode(tk);
        }
        if (verifying) {
            for (String s : this.locals) {
                this.inputs.remove(s);
            }
        }
        return new CompiledExpression(new FastTokenIterator(tokenSet));
    }

    private void reduceTrinary() {
        Object v1 = null;
        Object v2 = null;
        try {
            while (this.stk.size() > 1) {
                Integer operator = (Integer)this.stk.pop();
                v1 = this.stk.pop();
                v2 = this.stk.pop();
                switch (operator) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.stk.push(ParseTools.doOperations(v2, operator, v1));
                        break;
                    }
                    case 14: {
                        if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                            this.stk.clear();
                            this.stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                            return;
                        }
                        this.stk.push(null);
                        break;
                    }
                    case 15: {
                        this.stk.push(new Boolean(Pattern.compile(String.valueOf(v1)).matcher(String.valueOf(v2)).matches()));
                        break;
                    }
                    case 16: {
                        if (v1 instanceof Class) {
                            this.stk.push(new Boolean(((Class)v1).isInstance(v2)));
                            break;
                        }
                        this.stk.push(new Boolean(Class.forName(String.valueOf(v1)).isInstance(v2)));
                        break;
                    }
                    case 35: {
                        if (v1 instanceof Class) {
                            this.stk.push(new Boolean(DataConversion.canConvert(v2.getClass(), (Class)v1)));
                            break;
                        }
                        this.stk.push(new Boolean(DataConversion.canConvert(v2.getClass(), Class.forName(String.valueOf(v1)))));
                        break;
                    }
                    case 17: {
                        this.stk.push(new Boolean(ParseTools.containsCheck(v2, v1)));
                        break;
                    }
                    case 21: {
                        this.stk.push(new Integer(ExpressionCompiler.asInt(v2) & ExpressionCompiler.asInt(v1)));
                        break;
                    }
                    case 22: {
                        this.stk.push(new Integer(ExpressionCompiler.asInt(v2) | ExpressionCompiler.asInt(v1)));
                        break;
                    }
                    case 23: {
                        this.stk.push(new Integer(ExpressionCompiler.asInt(v2) ^ ExpressionCompiler.asInt(v1)));
                        break;
                    }
                    case 25: {
                        this.stk.push(new Integer(ExpressionCompiler.asInt(v2) << ExpressionCompiler.asInt(v1)));
                        break;
                    }
                    case 27: {
                        int iv2 = ExpressionCompiler.asInt(v2);
                        if (iv2 < 0) {
                            iv2 *= -1;
                        }
                        this.stk.push(new Integer(iv2 << ExpressionCompiler.asInt(v1)));
                        break;
                    }
                    case 24: {
                        this.stk.push(new Integer(ExpressionCompiler.asInt(v2) >> ExpressionCompiler.asInt(v1)));
                        break;
                    }
                    case 26: {
                        this.stk.push(new Integer(ExpressionCompiler.asInt(v2) >>> ExpressionCompiler.asInt(v1)));
                        break;
                    }
                    case 18: {
                        this.stk.push(new StringAppender(String.valueOf(v2)).append(String.valueOf(v1)).toString());
                        break;
                    }
                    case 19: {
                        this.stk.push(new Boolean(Soundex.soundex(String.valueOf(v1)).equals(Soundex.soundex(String.valueOf(v2)))));
                        break;
                    }
                    case 20: {
                        this.stk.push(new Float(PropertyTools.similarity(String.valueOf(v1), String.valueOf(v2))));
                    }
                }
            }
        }
        catch (ClassCastException e) {
            if ((this.fields & 0x2000) == 0) {
                this.fields |= 0x2000;
                Token tk = this.nextToken();
                if (tk != null) {
                    this.stk.push(v1, this.nextToken(), tk.getOperator());
                    this.reduceTrinary();
                    return;
                }
            }
            throw new CompileException(new StringBuffer("syntax error or incomptable types (left=").append(v1 != null ? v1.getClass().getName() : "null").append(", right=").append(v2 != null ? v2.getClass().getName() : "null").append(")").toString(), this.expr, this.cursor, e);
        }
        catch (Exception e) {
            throw new CompileException(new StringBuffer("failed to subEval expression: <<").append(new String(this.expr)).append(">>").toString(), e);
        }
    }

    private static int asInt(Object o) {
        return (Integer)o;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public List<String> getLocals() {
        return this.locals;
    }

    public ExpressionCompiler(String expression) {
        this.setExpression(expression);
    }

    public ExpressionCompiler(char[] expression) {
        this.setExpression(expression);
    }
}

