/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.Serializable;
import java.util.ArrayList;
import org.mvel.Token;
import org.mvel.TokenIterator;
import org.mvel.util.StringAppender;

public class FastTokenIterator
implements TokenIterator,
Serializable {
    private final Token[] token;
    private int length = 0;
    private int cursor = 0;

    public FastTokenIterator(Token[] token) {
        this.token = token;
        this.length = token.length;
    }

    public FastTokenIterator(FastTokenIterator fi) {
        this.token = fi.token;
        this.length = fi.length;
    }

    public FastTokenIterator(TokenIterator map) {
        if (map instanceof FastTokenIterator) {
            this.token = ((FastTokenIterator)map).token;
            this.length = ((FastTokenIterator)map).token.length;
        } else {
            ArrayList<Token> tokens = new ArrayList<Token>();
            map.reset();
            while (map.hasMoreTokens()) {
                tokens.add(map.nextToken());
            }
            this.length = tokens.size();
            this.token = tokens.toArray(new Token[this.length]);
        }
    }

    public void reset() {
        this.cursor = 0;
    }

    public Token firstToken() {
        return this.token[0];
    }

    public Token nextToken() {
        if (this.cursor < this.length) {
            return this.token[this.cursor++];
        }
        return null;
    }

    public void skipToken() {
        ++this.cursor;
    }

    public Token peekNext() {
        if (this.cursor < this.length) {
            return this.token[this.cursor + 1];
        }
        return null;
    }

    public Token peekToken() {
        if (this.cursor < this.length) {
            return this.token[this.cursor];
        }
        return null;
    }

    public Token peekLast() {
        if (this.cursor > 0) {
            return this.token[this.cursor - 1];
        }
        return null;
    }

    public Token tokensBack(int offset) {
        if (this.cursor - offset >= 0) {
            return this.token[this.cursor - offset];
        }
        return null;
    }

    public void back() {
        --this.cursor;
    }

    public boolean hasMoreTokens() {
        return this.cursor < this.length;
    }

    public String showTokenChain() {
        StringAppender sb = new StringAppender();
        int i = 0;
        while (i < this.length) {
            sb.append("(" + i + "): <<" + this.token[i].getName() + ">> = <<" + this.token[i].getLiteralValue() + ">> [" + (this.token[i].getLiteralValue() != null ? this.token[i].getLiteralValue().getClass() : "null") + "]").append("\n");
            ++i;
        }
        return sb.toString();
    }

    public int size() {
        return this.length;
    }

    public int index() {
        return this.cursor;
    }
}

