/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mvel.CompileException;
import org.mvel.MVEL;
import org.mvel.TemplateRegistry;
import org.mvel.util.StringAppender;

public class MVELTemplateRegistry
implements TemplateRegistry {
    private Map<String, String> registry = Collections.EMPTY_MAP;

    public String getTemplate(String name) {
        return this.registry.get(name);
    }

    public void registerTemplate(String name, String template) {
        if (this.registry == Collections.EMPTY_MAP) {
            this.registry = MVEL.THREAD_SAFE ? Collections.synchronizedMap(new HashMap()) : new HashMap<String, String>();
        }
        this.registry.put(name, template);
    }

    public void registerTemplate(Reader reader) {
        if (reader == null) {
            throw new CompileException("Reader cannot be null");
        }
        int nameStart = -1;
        int nameEnd = -1;
        int contentStart = -1;
        int contentEnd = -1;
        StringAppender sb = new StringAppender();
        try {
            int c = 0;
            while ((c = reader.read()) != -1) {
                char ch = (char)c;
                if ('<' == (char)c && sb.charAt(sb.length() - 1) == '<' && sb.charAt(sb.length() - 2) == '=' && sb.charAt(sb.length() - 3) == ':' && sb.charAt(sb.length() - 4) == ':') {
                    contentStart = sb.length() + 1;
                    int pos = sb.length() - 4;
                    while (sb.charAt(pos) != ')' && sb.charAt(pos - 1) != '(') {
                        --pos;
                    }
                    nameEnd = pos;
                    while (pos != -1 && sb.charAt(pos) != '\n' && sb.charAt(pos) != '\r' && sb.charAt(pos) != ' ') {
                        --pos;
                    }
                    nameStart = pos + 1;
                }
                if (':' == (char)c && sb.charAt(sb.length() - 1) == ':' && sb.charAt(sb.length() - 2) == '=' && sb.charAt(sb.length() - 3) == '>' && sb.charAt(sb.length() - 4) == '>') {
                    contentEnd = sb.length() - 4;
                    this.registerTemplate(new String(sb.getChars(nameStart, nameEnd - nameStart - 1)), new String(sb.getChars(contentStart, contentEnd - contentStart)));
                    nameStart = -1;
                    nameEnd = -1;
                    contentStart = -1;
                    contentEnd = -1;
                }
                sb.append((char)c);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public Iterator iterateTemplates() {
        return this.registry.keySet().iterator();
    }
}

